% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.spectrum.R
\name{interpolate_spectrum}
\alias{interpolate_spectrum}
\title{Calculate spectral values at a different set of wavelengths}
\usage{
interpolate_spectrum(w.length.in, s.irrad, w.length.out, fill = NA)
}
\arguments{
\item{w.length.in}{numeric array of wavelengths (nm)}

\item{s.irrad}{a numeric array of spectral values}

\item{w.length.out}{numeric array of wavelengths (nm)}

\item{fill}{a value to be assigned to out of range wavelengths}
}
\value{
a numeric array of interpolated spectral values
}
\description{
For example interpolate spectral irradiance (or spectral transmittance)
values at new wavelengths values.
}
\note{
The current version of interpolate uses \code{spline} if fewer than 25
data points are available. Otherwise it uses \code{approx}. In the first case
a cubic spline is used, in the second case linear interpolation, which should
be faster.
}
\examples{

my.w.length <- 300:700
my.s.e.irrad <-
  with(sun.data, interpolate_spectrum(w.length, s.e.irrad, my.w.length))
plot(my.s.e.irrad ~ my.w.length)
lines(s.e.irrad ~ w.length, data=sun.data)

}
