% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.tag.r
\name{wb2tagged_spct}
\alias{wb2tagged_spct}
\title{Create tagged spectrum from wavebands}
\usage{
wb2tagged_spct(
  w.band,
  use.hinges = TRUE,
  short.names = TRUE,
  chroma.type = "CMF",
  ...
)
}
\arguments{
\item{w.band}{waveband or list of waveband objects The waveband(s) determine
the region(s) of the spectrum that are tagged and the wavelengths returned
in variable \code{w.length}.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}

\item{short.names}{logical Flag indicating whether to use short or long names
for wavebands.}

\item{chroma.type}{character telling whether "CMF", "CC", or "both" should be
returned for human vision, or an object of class \code{chroma_spct} for any
other trichromic visual system.}

\item{...}{ignored (possibly used by derived methods).}
}
\value{
A spectrum as returned by \code{\link{wb2spct}} but additionally
  tagged using function \code{\link{tag}}
}
\description{
Create a tagged \code{generic_spct} object with wavelengths from the range of
wavebands in a list, and names of the same bands as factor levels, and
corresponding color definitions. The spectrum is not suitable for plotting
labels, symbols, rectangles or similar, as the midpoint of each waveband is
not added to the spectrum.
}
\seealso{
Other tagging and related functions: 
\code{\link{is_tagged}()},
\code{\link{tag}()},
\code{\link{untag}()},
\code{\link{wb2rect_spct}()},
\code{\link{wb2spct}()}
}
\concept{tagging and related functions}
