% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.se.r
\name{s_se}
\alias{s_se}
\alias{s_se.default}
\alias{s_se.source_mspct}
\alias{s_se.response_mspct}
\alias{s_se.filter_mspct}
\alias{s_se.reflector_mspct}
\alias{s_se.calibration_mspct}
\alias{s_se.cps_mspct}
\alias{s_se.raw_mspct}
\title{Standard Error of a collection of spectra}
\usage{
s_se(x, na.rm, ...)

\method{s_se}{default}(x, na.rm = FALSE, ...)

\method{s_se}{source_mspct}(x, na.rm = FALSE, ...)

\method{s_se}{response_mspct}(x, na.rm = FALSE, ...)

\method{s_se}{filter_mspct}(x, na.rm = FALSE, ...)

\method{s_se}{reflector_mspct}(x, na.rm = FALSE, ...)

\method{s_se}{calibration_mspct}(x, na.rm = FALSE, ...)

\method{s_se}{cps_mspct}(x, na.rm = FALSE, ...)

\method{s_se}{raw_mspct}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An R object. Currently this package defines methods for collections
of spectral objects.}

\item{na.rm}{logical. A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  "filter_mspct" object, the returned object is of class "generic_spct",
  containing the standard error among the spectra at each wavelength
  in a column with name ending in ".se".
}
\description{
A method to compute the standard error of values across members of a
collections of spectra. Computes the standard error at each wavelength
across all the spectra in the collection returning a spectral object.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: 

\item \code{source_mspct}: 

\item \code{response_mspct}: 

\item \code{filter_mspct}: 

\item \code{reflector_mspct}: 

\item \code{calibration_mspct}: 

\item \code{cps_mspct}: 

\item \code{raw_mspct}: 
}}

\note{
Omission of NAs is done separately at each wavelength. Interpolation is
  not applied, so all spectra in \code{x} must share the same set of
  wavelengths.

  Objects of classes raw_spct and cps_spct can contain data from multiple
  scans. This functions are implemented for these classes only for the case
  when all member spectra contain data for a single scan, or spliced into a
  single column in the case of cps_spct members.
}
