% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.absorptance.R
\name{absorptance}
\alias{absorptance}
\alias{absorptance.default}
\alias{absorptance.filter_spct}
\alias{absorptance.object_spct}
\alias{absorptance.filter_mspct}
\alias{absorptance.object_mspct}
\title{Absorptance}
\usage{
absorptance(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{absorptance}{default}(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{absorptance}{filter_spct}(
  spct,
  w.band = NULL,
  quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = NULL,
  naming = "default",
  ...
)

\method{absorptance}{object_spct}(
  spct,
  w.band = NULL,
  quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = NULL,
  naming = "default",
  ...
)

\method{absorptance}{filter_mspct}(
  spct,
  w.band = NULL,
  quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = NULL,
  naming = "default",
  ...,
  attr2tb = NULL,
  idx = "spct.idx"
)

\method{absorptance}{object_mspct}(
  spct,
  w.band = NULL,
  quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = NULL,
  naming = "default",
  ...,
  attr2tb = NULL,
  idx = "spct.idx",
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{spct}{an R object.}

\item{w.band}{waveband or list of waveband objects or a numeric vector of
length two. The waveband(s) determine the region(s) of the spectrum that
are summarized. If a numeric range is supplied a waveband object is
constructed on the fly from it.}

\item{quantity}{character string One of "average" or "mean", "total",
"contribution", "contribution.pc", "relative" or "relative.pc".}

\item{wb.trim}{logical Flag, if TRUE wavebands crossing spectral data
boundaries are trimmed and otherwise ignored.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}

\item{...}{other arguments (possibly used by derived methods).}

\item{naming}{character one of "long", "default", "short" or "none". Used to
select the type of names to assign to returned value.}

\item{attr2tb}{character vector, see \code{\link{add_attr2tb}} for the syntax for \code{attr2tb} passed as is to formal parameter \code{col.names}.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A named \code{numeric} vector in the case of methods for individual
  spectra, with one value for each \code{waveband} passed to parameter
  \code{w.band}. A \code{data.frame} in the case of collections of spectra,
  containing one column for each \code{waveband} object, an index column with
  the names of the spectra, and optionally additional columns with metadata
  values retrieved from the attributes of the member spectra.

  By default values are only integrated, but depending on the argument passed
  to parameter \code{quantity} they can be re-expressed as relative fractions
  or percentages. In the case of vector output, \code{names} attribute is set
  to the name of the corresponding waveband unless a named list is supplied
  in which case the names of the list members are used.
}
\description{
Function to calculate the mean, total, or other summary of absorptance for
spectral data stored in a \code{filter_spct} or in an \code{object_spct}.
Absorptance is a different quantity than absorbance.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{filter_spct}: Specialization for filter spectra

\item \code{object_spct}: Specialization for object spectra

\item \code{filter_mspct}: Calculates absorptance from a \code{filter_mspct}

\item \code{object_mspct}: Calculates absorptance from a \code{object_mspct}
}}

\note{
The \code{use.hinges} parameter controls speed optimization. The
  defaults should be suitable in most cases. Only the range of wavelengths
  in the wavebands is used and all BSWFs are ignored.
}
\examples{
absorptance(black_body.spct, new_waveband(400,500))
absorptance(white_body.spct, new_waveband(300,400))
absorptance(black_body.spct, split_bands(c(400,700), length.out = 3))
absorptance(black_body.spct, split_bands(c(400,700), length.out = 3),
        quantity = "average")
absorptance(black_body.spct, split_bands(c(400,700), length.out = 3),
        quantity = "total")
absorptance(black_body.spct, split_bands(c(400,700), length.out = 3),
        quantity = "relative")
absorptance(black_body.spct, split_bands(c(400,700), length.out = 3),
        quantity = "relative.pc")
absorptance(black_body.spct, split_bands(c(400,700), length.out = 3),
        quantity = "contribution")
absorptance(black_body.spct, split_bands(c(400,700), length.out = 3),
        quantity = "contribution.pc")

}
