% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.operators.r
\name{A2T}
\alias{A2T}
\alias{A2T.default}
\alias{A2T.numeric}
\alias{A2T.filter_spct}
\alias{A2T.filter_mspct}
\title{Convert absorbance into transmittance}
\usage{
A2T(x, action, byref, ...)

\method{A2T}{default}(x, action = NULL, byref = FALSE, ...)

\method{A2T}{numeric}(x, action = NULL, byref = FALSE, ...)

\method{A2T}{filter_spct}(x, action = "add", byref = FALSE, ...)

\method{A2T}{filter_mspct}(x, action = "add", byref = FALSE, ..., .parallel = FALSE, .paropts = NULL)
}
\arguments{
\item{x}{an R object}

\item{action}{a character string}

\item{byref}{logical indicating if new object will be created by reference or
by copy of \code{x}}

\item{...}{not used in current version}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A copy of \code{x} with a column \code{Tfr} added and \code{A} and
  \code{Afr} possibly deleted except for \code{w.length}. If \code{action =
  "replace"}, in all cases, the additional columns are removed, even if no
  column needs to be added.
}
\description{
Function that converts absorbance (a.u.) into transmittance (fraction).
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method for generic function

\item \code{numeric}: method for numeric vectors

\item \code{filter_spct}: Method for filter spectra

\item \code{filter_mspct}: Method for collections of filter spectra
}}

\seealso{
Other quantity conversion functions: 
\code{\link{Afr2T}()},
\code{\link{T2Afr}()},
\code{\link{T2A}()},
\code{\link{any2T}()},
\code{\link{as_quantum}()},
\code{\link{e2qmol_multipliers}()},
\code{\link{e2quantum_multipliers}()},
\code{\link{e2q}()},
\code{\link{q2e}()}
}
\concept{quantity conversion functions}
