% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{getFilterProperties}
\alias{getFilterProperties}
\alias{filter_properties}
\alias{getFilterProperties.default}
\alias{getFilterProperties.filter_spct}
\alias{getFilterProperties.summary_filter_spct}
\alias{getFilterProperties.generic_mspct}
\title{Get the "filter.properties" attribute}
\usage{
getFilterProperties(x, return.null, ...)

filter_properties(x, return.null, ...)

\method{getFilterProperties}{default}(x, return.null = FALSE, ...)

\method{getFilterProperties}{filter_spct}(x, return.null = FALSE, ...)

\method{getFilterProperties}{summary_filter_spct}(x, return.null = FALSE, ...)

\method{getFilterProperties}{generic_mspct}(x, ..., idx = "spct.idx")
}
\arguments{
\item{x}{a filter_spct object}

\item{return.null}{logical If true, \code{NULL} is returned if the attribute
is not set, otherwise the expected list is returned with all fields set to
\code{NA}.}

\item{...}{Allows use of additional arguments in methods for other classes.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}
}
\value{
a list with fields named "Rfr.constant", "thickness" and "attenuation.mode".
  If the attribute is not set, and \code{return.null} is FALSE, a list with
  fields set to \code{NA} is returned, otherwise, \code{NULL}.
}
\description{
Function to read the "filter.properties" attribute of an existing filter_spct
or a filter_mspct.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default

\item \code{filter_spct}: generic_spct

\item \code{summary_filter_spct}: summary_generic_spct

\item \code{generic_mspct}: filter_mspct
}}

\note{
The method for collections of spectra returns the
  a tibble with a column of lists.
}
\examples{
filter_properties(polyester.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
