% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.multipliers.r
\name{calc_multipliers}
\alias{calc_multipliers}
\title{Spectral weights}
\usage{
calc_multipliers(
  w.length,
  w.band,
  unit.out = "energy",
  unit.in = "energy",
  use.cached.mult = FALSE,
  fill = 0
)
}
\arguments{
\item{w.length}{numeric vector of wavelengths (nm).}

\item{w.band}{waveband object.}

\item{unit.out}{character A string: "photon" or "energy", default is "energy".}

\item{unit.in}{character A string: "photon" or "energy", default is "energy".}

\item{use.cached.mult}{logical Flag indicating whether multiplier values
should be cached between calls.}

\item{fill}{numeric If \code{fill == NA} then values returned for wavelengths outside
the range of the waveband are set to \code{NA}.}
}
\value{
a numeric vector of multipliers of the same length as \code{w.length}.
}
\description{
Calculate multipliers for selecting a range of wavelengths and optionally
applying a biological spectral weighting function (BSWF) and wavelength
normalization. This function returns numeric multipliers that can be used to
select a waveband and apply a weight.
}
\examples{
with(sun.data, calc_multipliers(w.length, new_waveband(400,700),"photon"))
with(sun.data, calc_multipliers(w.length, new_waveband(400,700),"photon"), use.cached.mult = TRUE)

}
\seealso{
Other low-level functions operating on numeric vectors.: 
\code{\link{as_energy}()},
\code{\link{as_quantum_mol}()},
\code{\link{div_spectra}()},
\code{\link{energy_irradiance}()},
\code{\link{energy_ratio}()},
\code{\link{insert_hinges}()},
\code{\link{integrate_xy}()},
\code{\link{interpolate_spectrum}()},
\code{\link{irradiance}()},
\code{\link{l_insert_hinges}()},
\code{\link{oper_spectra}()},
\code{\link{photon_irradiance}()},
\code{\link{photon_ratio}()},
\code{\link{photons_energy_ratio}()},
\code{\link{prod_spectra}()},
\code{\link{s_e_irrad2rgb}()},
\code{\link{split_energy_irradiance}()},
\code{\link{split_photon_irradiance}()},
\code{\link{subt_spectra}()},
\code{\link{sum_spectra}()},
\code{\link{trim_tails}()},
\code{\link{v_insert_hinges}()},
\code{\link{v_replace_hinges}()}
}
\concept{low-level functions operating on numeric vectors.}
