% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.utils.r
\name{thin_wl}
\alias{thin_wl}
\alias{thin_wl.default}
\alias{thin_wl.generic_spct}
\alias{thin_wl.source_spct}
\alias{thin_wl.response_spct}
\alias{thin_wl.filter_spct}
\alias{thin_wl.reflector_spct}
\alias{thin_wl.solute_spct}
\alias{thin_wl.raw_spct}
\alias{thin_wl.cps_spct}
\alias{thin_wl.object_spct}
\alias{thin_wl.chroma_spct}
\alias{thin_wl.calibration_spct}
\alias{thin_wl.generic_mspct}
\alias{thin_wl.chroma_mspct}
\alias{thin_wl.calibration_mspct}
\title{Thin the density of wavelength values}
\usage{
thin_wl(x, ...)

\method{thin_wl}{default}(x, ...)

\method{thin_wl}{generic_spct}(x, max.wl.step = 10, max.slope.delta = 0.001, col.names, ...)

\method{thin_wl}{source_spct}(
  x,
  max.wl.step = 10,
  max.slope.delta = 0.001,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...
)

\method{thin_wl}{response_spct}(
  x,
  max.wl.step = 10,
  max.slope.delta = 0.001,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...
)

\method{thin_wl}{filter_spct}(
  x,
  max.wl.step = 10,
  max.slope.delta = 0.001,
  qty.out = getOption("photobiology.filter.qty", default = "transmittance"),
  ...
)

\method{thin_wl}{reflector_spct}(x, max.wl.step = 10, max.slope.delta = 0.001, ...)

\method{thin_wl}{solute_spct}(x, max.wl.step = 10, max.slope.delta = 0.001, ...)

\method{thin_wl}{raw_spct}(x, max.wl.step = 10, max.slope.delta = 0.001, col.names, ...)

\method{thin_wl}{cps_spct}(x, max.wl.step = 10, max.slope.delta = 0.001, col.names, ...)

\method{thin_wl}{object_spct}(x, max.wl.step = 10, max.slope.delta = 0.001, col.names, ...)

\method{thin_wl}{chroma_spct}(x, ...)

\method{thin_wl}{calibration_spct}(x, ...)

\method{thin_wl}{generic_mspct}(x, max.wl.step = 10, max.slope.delta = 0.001, ...)

\method{thin_wl}{chroma_mspct}(x, ...)

\method{thin_wl}{calibration_mspct}(x, ...)
}
\arguments{
\item{x}{An R object}

\item{...}{additional named arguments passed down to \code{f}.}

\item{max.wl.step}{numeric. Largest allowed wavelength difference between
adjacent spectral values in nanometres (nm).}

\item{max.slope.delta}{numeric in 0 to 1. Largest allowed change in relative
slope of the spectral quantity per nm betweem adjacent pairs of values.}

\item{col.names}{character. Name of the column of \code{x} containing the
spectral data to check against \code{max.slope.delta}. Currently only one
column supported.}

\item{unit.out}{character Allowed values "energy", and "photon", or its alias
"quantum".}

\item{qty.out}{character Allowed values "transmittance", and "absorbance".}
}
\value{
An object of the same class as \code{x} but with a reduced density of
  wavelength values in those regions were slope is shallow and featureless.
}
\description{
Increase the wavelength step in stored spectral data in featureless regions
to save storage space.
}
\details{
The algorithm used for spectra is "naive" in an effort to keep it
  efficient. It works by iteratively attempting to delete every other
  observation along wavelengths, based on the criteria for maximum wavelength
  step and maximum relative step in the spectral variable between adjacent
  data values.
}
\section{Methods (by class)}{
\itemize{
\item \code{thin_wl(default)}: Default for generic function

\item \code{thin_wl(generic_spct)}: 

\item \code{thin_wl(source_spct)}: 

\item \code{thin_wl(response_spct)}: 

\item \code{thin_wl(filter_spct)}: 

\item \code{thin_wl(reflector_spct)}: 

\item \code{thin_wl(solute_spct)}: 

\item \code{thin_wl(raw_spct)}: 

\item \code{thin_wl(cps_spct)}: 

\item \code{thin_wl(object_spct)}: 

\item \code{thin_wl(chroma_spct)}: 

\item \code{thin_wl(calibration_spct)}: 

\item \code{thin_wl(generic_mspct)}: 

\item \code{thin_wl(chroma_mspct)}: 

\item \code{thin_wl(calibration_mspct)}: 

}}
\note{
The value of \code{max.slope.delta} is expressed as relative change in
  the slope of spectral variable per nanometre. This means that values
  between 0.0005 and 0.005 tend to work reasonably well. The best value
  will depend on the wavelength step of the input and noise in data. A
  moderate smoothing before thinning can sometimes help in the case of
  noisy data.
  The amount of thinning is almost always less than the value of criteria
  passed as argument as it is based on existing wavelength values. For
  example if we start with a spectrum with a uniform wavelength step of 1 nm,
  possible steps in the thinned spectrum are 2, 4, 8, 16, 32, etc. nm. The
  algorithm, does work with any step sizes, regular or variable in the input.
  Thinning is most effective for spectra with large "featureless" regions as
  the algorithm attempts not to discard information, contrary to smoothing or
  interpolation.
}
\examples{

nrow(yellow_gel.spct)
wl_stepsize(yellow_gel.spct)
thinned.spct <- thin_wl(yellow_gel.spct)
nrow(thinned.spct)
wl_stepsize(thinned.spct)

}
\seealso{
Other experimental utility functions: 
\code{\link{collect2mspct}()},
\code{\link{drop_user_cols}()},
\code{\link{uncollect2spct}()}
}
\concept{experimental utility functions}
