% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{getHowMeasured}
\alias{getHowMeasured}
\alias{how_measured}
\alias{getHowMeasured.default}
\alias{getHowMeasured.generic_spct}
\alias{getHowMeasured.summary_generic_spct}
\alias{getHowMeasured.generic_mspct}
\title{Get the "how.measured" attribute}
\usage{
getHowMeasured(x, ...)

how_measured(x, ...)

\method{getHowMeasured}{default}(x, ...)

\method{getHowMeasured}{generic_spct}(x, ...)

\method{getHowMeasured}{summary_generic_spct}(x, ...)

\method{getHowMeasured}{generic_mspct}(x, ..., idx = "spct.idx")
}
\arguments{
\item{x}{a generic_spct object}

\item{...}{Allows use of additional arguments in methods for other classes.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}
}
\value{
character vector An object containing a description of the data.
}
\description{
Function to read the "how.measured" attribute of an existing generic_spct
or a generic_mspct.
}
\section{Methods (by class)}{
\itemize{
\item \code{getHowMeasured(default)}: default

\item \code{getHowMeasured(generic_spct)}: generic_spct

\item \code{getHowMeasured(summary_generic_spct)}: summary_generic_spct

\item \code{getHowMeasured(generic_mspct)}: generic_mspct

}}
\note{
The method for collections of spectra returns the
  a tibble with a column of character strings.
}
\examples{
how_measured(sun.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
