% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.utils.r
\name{collect2mspct}
\alias{collect2mspct}
\title{Form a new collection}
\usage{
collect2mspct(
  .list = NULL,
  pattern = "*\\\\.spct$",
  collection.class = NULL,
  ...
)
}
\arguments{
\item{.list}{list of R objects}

\item{pattern}{character an optional regular expression, ignored if
\code{.list} is not \code{NULL}.}

\item{collection.class}{character vector}

\item{...}{additional named arguments passed down to the collection
constructor.}
}
\value{
By default a collection of spectra.
}
\description{
Form a collection of spectra from separate objects in the parent
frame of the call.
}
\details{
This is a convenience function that simplifies the creation of
  collections from existing objects of class \code{generic_spct} or a derived
  class. A list of objects con be passed as argument, or a search pattern. If
  a list is passed, no search is done. If \code{collection.class} is
  \code{NULL}, then all objects of class \code{generic_spct} or of a class
  derived from it are added to the collection. If objects of only one derived
  class are to be collected this class or that of the matching collection
  should be passed as argument to \code{collection.class}. Objects of other R
  classes are silently discarded, which simplifies the specification of
  search patterns. By default, i.e., if \code{collection.class} is
  \code{NULL}, if all the objects collected belong to the same class then the
  corresponding collection class will be returned, otherwise a
  \code{generic_mspct} object with heterogeneous members will be returned. To
  force the return of a \code{generic_mspct} even when the collected spectra
  all belong to the same class, pass \code{generic_mspct} as argument to
  \code{collection.class}. If the argument to \code{collection.class} is a
  vector containing two of more class names, only the matching spectra will
  be collected, and a \code{generic_mspct} will be returned. The returned
  object is created with the constructor for the class, and validated.
}
\examples{
collect2mspct() # returns empty generic_mspct object

sun1.spct <- sun.spct
sun2.spct <- sun.spct
kk.spct <- 10:30 # ignored
collect2mspct()
collect2mspct(collection.class = "generic_mspct")

pet1.spct <- polyester.spct
collect2mspct()
collect2mspct(collection.class = "source_mspct")
collect2mspct(collection.class = "filter_mspct")
collect2mspct(collection.class = "response_mspct")

}
\seealso{
Other experimental utility functions: 
\code{\link{drop_user_cols}()},
\code{\link{thin_wl}()},
\code{\link{uncollect2spct}()}
}
\concept{experimental utility functions}
