% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.class.r
\name{spread}
\alias{spread}
\alias{wl_expanse}
\alias{expanse}
\alias{expanse.default}
\alias{expanse.numeric}
\alias{expanse.waveband}
\alias{expanse.generic_spct}
\alias{expanse.generic_mspct}
\title{Expanse}
\usage{
spread(x, ...)

wl_expanse(x, ...)

expanse(x, ...)

\method{expanse}{default}(x, ...)

\method{expanse}{numeric}(x, ...)

\method{expanse}{waveband}(x, ...)

\method{expanse}{generic_spct}(x, ...)

\method{expanse}{generic_mspct}(x, ..., idx = "spct.idx")
}
\arguments{
\item{x}{an R object}

\item{...}{not used in current version}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}
}
\value{
A numeric value equal to \code{max(x) - min(x)}. In the case of
  spectral objects wavelength difference [\eqn{nm}]. For any other R object,
  according to available specialised methods of \code{\link{min}} and
  \code{\link{max}}.
}
\description{
A method that returns the expanse (\eqn{max(x) - min(x)}) for R objects. In
particular the wavelength [\eqn{nm}] expanse of the wavelength range of
objects of classes \code{waveband} or of class \code{generic_spct} or derived
(or the expanse of values in a \code{numeric} vector).
}
\section{Methods (by class)}{
\itemize{
\item \code{expanse(default)}: Default method for generic function

\item \code{expanse(numeric)}: Method for "numeric"

\item \code{expanse(waveband)}: Method for "waveband"

\item \code{expanse(generic_spct)}: Method for "generic_spct"

\item \code{expanse(generic_mspct)}: Method for "generic_mspct" objects.

}}
\examples{
expanse(10:20)
expanse(sun.spct)
wl_expanse(sun.spct)

expanse(sun.spct)

}
