% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{setFilterProperties}
\alias{setFilterProperties}
\alias{filter_properties<-}
\title{Set the "filter.properties" attribute}
\usage{
setFilterProperties(
  x,
  filter.properties = NULL,
  pass.null = FALSE,
  Rfr.constant = NA_real_,
  thickness = NA_real_,
  attenuation.mode = NA
)

filter_properties(x) <- value
}
\arguments{
\item{x}{a filter_spct object}

\item{filter.properties, value}{a list with fields named "Rfr.constant",
"thickness" and "attenuation.mode".}

\item{pass.null}{logical If TRUE, the parameters to the next three
parameters will be always ignored, otherwise they will be used to
build an object of class "filter.properties" when the argument to
filter.properties is NULL.}

\item{Rfr.constant}{numeric The value of the reflection factor (/1).}

\item{thickness}{numeric The thickness of the material.}

\item{attenuation.mode}{character One of "reflection", "absorption" or
"mixed".}
}
\value{
\code{x}
}
\description{
Function to set by reference the "filter.properties" attribute  of an existing
filter_spct object.
}
\details{
Storing filter properties allows inter-conversion between internal
  and total transmittance, as well as computation of transmittance for
  arbitrary thickness of the material. Whether computations are valid depend
  on the homogeneity of the material. The parameter \code{pass.null} makes
  it possible to remove the attribute.
}
\note{
This function alters \code{x} itself by reference and in addition
  returns \code{x} invisibly. If \code{x} is not a filter_spct object,
  \code{x} is not modified.
}
\examples{

my.spct <- polyester.spct
filter_properties(my.spct)
filter_properties(my.spct) <- NULL
filter_properties(my.spct)
filter_properties(my.spct, return.null = TRUE)
filter_properties(my.spct) <- list(Rfr.constant = 0.01,
                                   thickness = 125e-6,
                                   attenuation.mode = "absorption")
filter_properties(my.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
