% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mra.R
\name{mra_encode}
\alias{mra_encode}
\alias{mra_compare}
\title{Match Rating Approach Encoder}
\usage{
mra_encode(word, clean = TRUE)

mra_compare(x, y)
}
\arguments{
\item{word}{string or vector of strings to encode}

\item{clean}{if \code{TRUE}, return \code{NA} for unknown alphabetical characters}

\item{x}{MRA-encoded character vector}

\item{y}{MRA-encoded character vector}
}
\value{
The \code{mra_encode} function returns match rating approach
encoded character vector.  The \code{mra_compare} returns a boolean
vector which is \code{TRUE} if \code{x} and \code{y} pass the MRA
comparison test.
}
\description{
The Western Airlines matching rating approach name encoder
}
\details{
The variable \code{word} is the name to be encoded.  The variable
\code{maxCodeLen} is \emph{not} supported in this algorithm encoder
because the algorithm itself is dependent upon its six-character
length.  The variables \code{x} and \code{y} are MRA-encoded and are
compared to each other using the MRA comparison specification.

The \code{mra_encode} algorithm is only defined for inputs over the
standard English alphabet, \emph{i.e.}, "A-Z.". Non-alphabetical
characters are removed from the string in a locale-dependent fashion.
This strips spaces, hyphens, and numbers.  Other letters, such as
"Ü," may be permissible in the current locale but are unknown to
\code{mra_encode}.  For inputs outside of its known range, the output is
undefined and \code{NA} is returned and a \code{warning} this thrown.
If \code{clean} is \code{FALSE}, \code{mra_encode} attempts to process the
strings.  The default is \code{TRUE}.
}
\examples{
mra_encode("William")
mra_encode(c("Peter", "Peady"))
mra_encode("Stevenson")
}
\references{
G.B. Moore, J.L. Kuhns, J.L. Treffzs, and C.A. Montgomery,
\emph{Accessing Individual Records from Personal Data Files Using
Nonunique Identifiers,} US National Institute of Standards and
Technology, SP-500-2 (1977), p. 17.
}
\seealso{
Other phonics: 
\code{\link{caverphone}()},
\code{\link{cologne}()},
\code{\link{lein}()},
\code{\link{metaphone}()},
\code{\link{nysiis}()},
\code{\link{onca}()},
\code{\link{phonex}()},
\code{\link{phonics}()},
\code{\link{rogerroot}()},
\code{\link{soundex}()},
\code{\link{statcan}()}
}
\concept{phonics}
