% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onca.R
\name{onca}
\alias{onca}
\title{Oxford Name Compression Algorithm}
\usage{
onca(word, maxCodeLen = 4)
}
\arguments{
\item{word}{string or vector of strings to encode}

\item{maxCodeLen}{maximum length of the resulting encodings, in characters}
}
\value{
the ONCA encoded character vector
}
\description{
The Oxford Name Compression Algorithm name coding procedure
}
\details{
The variable \code{word} is the name to be encoded.  The variable
\code{maxCodeLen} is the limit on how long the returned name code
should be.  The default is 4.
}
\section{Caveats}{

The \code{onca} algorithm is only
defined for inputs over the standard English alphabet, \emph{i.e.},
"A-Z." For inputs outside this range, the output is undefined.
}

\examples{
onca("William")
onca(c("Peter", "Peady"))
onca("Stevenson", maxCodeLen = 8)

}
\references{
Gill, Leicester. "OX-LINK: the Oxford medical record linkage system." (1997).
}
\seealso{
Other phonics: \code{\link{caverphone}},
  \code{\link{cologne}}, \code{\link{lein}},
  \code{\link{metaphone}}, \code{\link{mra_encode}},
  \code{\link{nysiis}}, \code{\link{phonex}},
  \code{\link{rogerroot}}, \code{\link{soundex}},
  \code{\link{statcan}}
}
\concept{phonics}
