% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{metaphone}
\alias{metaphone}
\title{Generate phonetic versions of strings with Metaphone}
\usage{
metaphone(word, maxCodeLen = 10L)
}
\arguments{
\item{word}{string or vector of strings to encode}

\item{maxCodeLen}{maximum length of the resulting encodings, in characters}
}
\value{
a character vector containing the metaphones of \code{word},
or an NA if the \code{word} value is NA
}
\description{
The function \code{metaphone} phonentically encodes the
given string using the metaphone algorithm.
}
\details{
There is some discrepency
with respect to how the metaphone algorithm actually works. For
instance, there is a version in the Java Apache Commons library.
There is a version provided within PHP. These do not provide the same
results.  On the questionable theory that the implementation in PHP
is probably more well known, this code should match it in output.

This implementation is based on a Javascript implementation which is
itself based on the PHP internal implementation.

The variable \code{maxCodeLen} is the limit on how long the returned
metaphone should be.
}
\section{Caveats}{

The \code{metaphone} algorithm is only
defined for inputs over the standard English alphabet, \emph{i.e.},
"A-Z." For inputs outside this range, the output is undefined.
}

\examples{
metaphone("wheel")
metaphone(c("school", "benji"))

}
\seealso{
Other phonics: \code{\link{caverphone}},
  \code{\link{cologne}}, \code{\link{lein}},
  \code{\link{mra_encode}}, \code{\link{nysiis}},
  \code{\link{onca}}, \code{\link{phonex}},
  \code{\link{rogerroot}}, \code{\link{soundex}},
  \code{\link{statcan}}
}
\concept{phonics}
