% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_textgrid.R
\name{annotate_textgrid}
\alias{annotate_textgrid}
\title{Annotate textgrid}
\usage{
annotate_textgrid(
  annotation,
  textgrid,
  tier = 1,
  each = 1,
  backup = TRUE,
  write = TRUE
)
}
\arguments{
\item{annotation}{vector of stimuli}

\item{textgrid}{character with a filename or path to the TextGrid}

\item{tier}{value that could be either ordinal number of the tier either name
of the tier}

\item{each}{non-negative integer. Each element of x is repeated each times}

\item{backup}{logical. If TRUE (by default) it creates a backup tier.}

\item{write}{logical. If TRUE (by dafault) it overwrites an existing tier.}
}
\value{
a string that contain TextGrid. If argument write is \code{TRUE},
then no output.
}
\description{
Annotates textgrids. It is possible to define step in the argument "each",
so each second element of the tier will be annotated.
}
\examples{
annotate_textgrid(
  annotation = c("", "t", "e", "s", "t"),
  textgrid = system.file("extdata",
    "test.TextGrid",
    package = "phonfieldwork"
  ),
  tier = 2, write = FALSE
)
}
\author{
George Moroz <agricolamz@gmail.com>
}
