% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parameter_Global_Year.R
\name{Parameter_Global_Year}
\alias{Parameter_Global_Year}
\title{Transform a set of parameters from Year to global effect, or reverse}
\usage{
Parameter_Global_Year(
  parameters = stop("A set of parameters must be indicated"),
  parname = c("Peak", "LengthB", "LengthE", "B", "E", "Length"),
  series = NULL,
  sep_year = "-",
  perYear = TRUE
)
}
\arguments{
\item{parameters}{Set of current parameters}

\item{parname}{Name of parameter to transform}

\item{series}{Set of series (see description)}

\item{sep_year}{Character used to separate the year}

\item{perYear}{TRUE if year-specific values must be setup}
}
\value{
Return a set of modified parameters
}
\description{
This function is used to transform a set of parameters 
that uses Peak, LengthB, LengthE, B, E, or Length to the same parameter 
with Year effect, or reverse.\cr
The parameter series can be or a result from add_phenology() or from 
fit_phenology() or simply a vector of names.
}
\details{
Parameter_Global_Year transforms a set of parameters from Year to global effect, or reverse
}
\examples{
\dontrun{
Parameter_Global_Year(parameters=c("Peak_Beach1-2018"=151, "Peak_Beach1-2019"=161), 
                     parname="Peak", perYear=FALSE)
Parameter_Global_Year(parameters=c("Peak"=151), 
                      series = c("beach1", "beach2"), 
                     parname="Peak", perYear=TRUE)
}
}
\author{
Marc Girondot
}
