\name{plot_phenology}
\alias{plot_phenology}
\title{Plot the phenology from a result.}
\usage{
  plot_phenology(result = NULL, data = NULL,
    parameters = NULL, parametersfixed = NA,
    series = "all", pdf = FALSE, help = FALSE, ...)
}
\arguments{
  \item{result}{A result file generated by fit_phenology}

  \item{data}{A dataset generated by add_format}

  \item{pdf}{TRUE or FALSE, indicates if a pdf file is
  generated.}

  \item{parametersfixed}{Set of fixed parameters}

  \item{parameters}{Set of parameters to be changed}

  \item{series}{Number of series to be analyzed or 'all'}

  \item{...}{Parameters used for graphics}

  \item{help}{If TRUE, an help is displayed}
}
\value{
  Return A map generated with map_phenology
}
\description{
  The function "plot_phenology" plots the phenology graph
  from a result.
}
\details{
  plot_phenology plots the phenology.
}
\examples{
library(phenology)
# Read a file with data
# Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", , header=FALSE)
data(Gratiot)
# Generate a formatted list nammed data_Gratiot
data_Gratiot<-add_format(origin=NULL, add=Gratiot, name="Complete", reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, parametersfixed=NULL)
# Run the optimisation
# result_Gratiot<-fit_phenology(data=data_Gratiot, parametersfit=parg, parametersfixed=NULL, trace=1)
data(result_Gratiot)
# Plot the phenology and get some stats
plot_phenology(result=result_Gratiot, pdf=FALSE)
}
\author{
  Marc Girondot
}

