% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_input.R
\name{plot_input}
\alias{plot_input}
\title{Plot INPUT returned by check_input}
\usage{
plot_input(INPUT, wmin = 0.2, show.y0 = TRUE, ...)
}
\arguments{
\item{INPUT}{A list object with the elements of \code{t}, \code{y}, \code{w},
\code{Tn} (optional) and \code{ylu}, returned by \code{\link[=check_input]{check_input()}}.}

\item{wmin}{Double, minimum weigth (i.e. weight of snow, ice and cloud).}

\item{show.y0}{boolean. Whether to show original time-series \code{y0} or processed time-series \code{y} by
\code{\link[=check_input]{check_input()}}?}

\item{...}{other parameter will be ignored.}
}
\description{
Plot INPUT returned by check_input
}
\examples{
library(phenofit)
data("MOD13A1")

dt <- tidy_MOD13.gee(MOD13A1$dt)
st <- MOD13A1$st

sitename <- dt$site[1]
d     <- dt[site == sitename, ] # get the first site data
sp    <- st[site == sitename, ] # station point
# global parameter
IsPlot = TRUE
print  = FALSE
nptperyear = 23
ypeak_min  = 0.05

dnew     <- add_HeadTail(d, nptperyear = nptperyear) # add one year in head and tail
INPUT    <- check_input(dnew$t, dnew$y, dnew$w, d$QC_flag, nptperyear,
                        maxgap = nptperyear/4, alpha = 0.02, wmin = 0.2)
plot_input(INPUT)
}
