% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{text}
\alias{text}
\alias{text<-}
\alias{set_text}
\title{Return or set text}
\usage{
text(x, ...)

text(x) <- value

set_text(x, value)
}
\arguments{
\item{x}{A \code{hf_line} object}

\item{...}{Additonal arguments passed to method dispatch}

\item{value}{A character vector of length 0, 1, or 2 to set the text value
of a \code{hf_line} object.}
}
\value{
For \code{text()}, the text vector of the supplied \code{hf_line}
  object. For \code{`text<-()`} and \code{set_text()}, the modfied object.
}
\description{
These property functions modify or return the fonts of a \code{rtf_doc} object.
\code{text()} will always return a vector of length 2. If the text is only
of length one an empty string will be appended.
}
\examples{
library(huxtable)
ht <- huxtable(
  column1 = 1:5,
  column2 = letters[1:5]
)
rtf <- rtf_doc(ht, list(hf_line("aTitle")))

text(rtf$titles[[1]])
# Returns "aTitle" ""

text(rtf$titles[[1]]) <- "aDifferentTitle"
# Sets titles to "aDifferentTitle"

}
