% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/des_two_stage.R
\name{des_two_stage}
\alias{des_two_stage}
\title{Design a two-stage two-arm randomised clinical trial assuming a Bernoulli
distributed primary outcome variable}
\usage{
des_two_stage(
  type = "binomial",
  alpha = 0.1,
  beta = 0.2,
  delta = 0.2,
  ratio = 1,
  Pi0 = 0.1,
  Pi1 = Pi0[1],
  nCmax = 50L,
  equal = T,
  w = c(1, 0, 0, 0, 0),
  piO = Pi0[1],
  efficacy = FALSE,
  futility = TRUE,
  efficacy_type = 0L,
  efficacy_param = NULL,
  futility_type = 1L,
  futility_param = 0L,
  summary = FALSE
)
}
\arguments{
\item{type}{A \code{\link{character}} string indicating the chosen design
framework/test statistic to assume. Must be one of \code{"barnard"},
\code{"binomial"}, \code{"fisher"}, or \code{"sat"}. Defaults to
\code{"binomial"}.}

\item{alpha}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&alpha;</i>}}{\eqn{\alpha}}, the significance level
(i.e., the type-I error-rate). Defaults to \code{0.1}.}

\item{beta}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&beta;</i>}}{\eqn{\beta}}, used in the definition of
the desired power (i.e., the type-II error-rate). Defaults to \code{0.2}.}

\item{delta}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&delta;</i>}}{\eqn{\delta}}, the treatment effect
assumed in the power calculation. Defaults to \code{0.2}.}

\item{ratio}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>r</i>}}{\eqn{r}}, the allocation ratio to
the experimental arm, relative to the control arm. Defaults to \code{1}.}

\item{Pi0}{A \code{\link{numeric}} \code{\link{vector}} indicating the
chosen values of the control arm response rate to control the type-I
error-rate to level \ifelse{html}{\out{<i>&alpha;</i>}}{\eqn{\alpha}} for.
Must either be of \code{\link{length}} one, indicating a single point, or of
\code{\link{length}} two. In this case, the elements indicate the
range of possible response rates to allow for. Defaults to \code{0.1}.}

\item{Pi1}{A \code{\link{numeric}} \code{\link{vector}} indicating the
chosen values of the control arm response rate to allow for in the power
calculations. Must either be of \code{\link{length}} one,
indicating a single point, or of \code{\link{length}} two. In this case, the
elements indicate the range of possible response rates to allow for. Defaults
to \code{Pi0[1]}.}

\item{nCmax}{A \code{\link{numeric}} indicating the maximum value of the
sample size in the control arm (across both stages) to consider in the search
procedure. Defaults to \code{50L}.}

\item{equal}{A \code{\link{logical}} variable indicating whether the sample
size of the two stages should be equal. Defaults to \code{TRUE}.}

\item{w}{A \code{\link{numeric}} \code{\link{vector}} indicating the weights
to use in the optimality criteria. Must be of \code{\link{length}} five, with
all elements greater than or equal to zero, and at least one of the first
four elements strictly positive. Defaults to \code{c(1, 0, 0, 0, 0)}.}

\item{piO}{A \code{\link{numeric}} indicating the value of the control
arm response rate to assume in the optimality criteria. Defaults to
\code{Pi0[1]}.}

\item{efficacy}{Only used if \code{type} is one of \code{"barnard"},
\code{"binomial"}, or \code{"sat"}. Then, it is a
\code{\link{logical}} variable indicating whether to include early stopping
for efficacy in the design. Defaults to \code{FALSE}.}

\item{futility}{Only used if \code{type} is one of \code{"barnard"},
\code{"binomial"}, or \code{"sat"}. Then, it is a
\code{\link{logical}} variable indicating whether to include early stopping
for futility in the design. Defaults to \code{TRUE}.}

\item{efficacy_type}{Only used if \code{type} is \code{"fisher"}. Then, it is
a \code{\link{numeric}} indicating whether, and which type of, early stopping
for efficacy to include in the design. See the vignette for details. Defaults
to \code{0L}.}

\item{efficacy_param}{Only used if \code{type} is \code{"fisher"} and
\code{efficacy_type} is not equal to \code{0L}. Then, it is a
\code{\link{numeric}} that influences the precise way in which an efficacy
boundary is specified. See the vignette for details. Defaults to \code{NULL}.}

\item{futility_type}{Only used if \code{type} is \code{"fisher"}. Then, it is
a \code{\link{numeric}} indicating whether, and which type of, early stopping
for futility to include in the design. See the vignette for details. Defaults
to \code{1L}.}

\item{futility_param}{Only used if \code{type} is \code{"fisher"} and
\code{futility_type} is not equal to \code{0L}. Then, it is a
\code{\link{numeric}} that influences the precise way in which a futility
boundary is specified. See the vignette for details. Defaults to \code{1L}.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}} with additional class \code{"ph2rand_des"},
containing each of the input parameters along with several additional
variables, including
\itemize{
\item A \code{\link{list}} in the slot \code{$boundaries} giving the
rejection boundaries of the optimal design. The names of these elements
depends on the value of \code{type}.
\item A \code{\link{tibble}} in the slot \code{$feasible} summarising the
operating characteristics of the feasible designs.
\item A \code{\link{numeric}} \code{\link{vector}} in the slot \code{$nC}
giving the sample sizes in the control arm in each stage for the optimal
design.
\item A \code{\link{numeric}} \code{\link{vector}} in the slot \code{$nE}
giving the sample sizes in the experimental arm in each stage for the optimal
design.
\item A \code{\link{tibble}} in the slot \code{$opchar} summarising the
operating characteristics of the optimal design.
}
}
\description{
\code{des_two_stage} determines two-stage two-arm randomised clinical trial
designs, assuming the primary outcome variable is Bernoulli distributed. It
supports a flexible framework for specifying which scenarios to control the
type-I and type-II error-rates for, and allows for design determination
assuming a variety of test statistics. In all instances, \code{des_two_stage}
computes the optimal required sample size in each arm in each stage, the
associated optimal stopping boundaries, and returns information on key
operating characteristics.
}
\examples{
# The design for the default parameters
des       <- des_two_stage()
# Controlling the type-I/II error-rates over a range of possible response
# rates
des_range <- des_two_stage(Pi0 = c(0, 1),
                           Pi1 = c(0, 0.8))
}
\seealso{
\code{\link{des_one_stage}}, \code{\link{opchar}},
\code{\link{pmf}}, \code{\link{terminal}}, \code{\link{plot.ph2rand_des}},
\code{\link{summary.ph2rand_des}}.
}
