% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguImputation.R
\name{pgu.imputation}
\alias{pgu.imputation}
\title{pgu.imputation}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
Analyses and substitutes imputation sites in a data set.
}
\details{
Analyses imputation sites in a data set.
Replaces imputation sites by missing values and substitutes NAs
by classical and ML-powered substitution algorithms.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch, \email{malkusch@med.uni-frankfurt.de}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{imputationStatistics}}{Returns the instance variable imputationStatistics.
(tibble::tibble)}

\item{\code{imputationSites}}{Returns the instance variable imputationSites.
(tibble::tibble)}

\item{\code{one_hot_df}}{Returns the positions of missings in one_hot encoding
(tibble::tibble)}

\item{\code{imputationSiteDistribution}}{Returns the instance variable imputationSiteDistribution.
(matrix)}

\item{\code{imputationAgentAlphabet}}{Returns the instance variable imputationagentAlphabet.
(character)}

\item{\code{imputationAgent}}{Returns the instance variable imputationAgent.
(character)}

\item{\code{setImputationAgent}}{Sets the instance variable imputationAgent.
(character)}

\item{\code{nNeighbors}}{Returns the instance variable nNeighbors.
(integer)}

\item{\code{setNNeighbors}}{Sets the instance variable nNeighbors.
(integer)}

\item{\code{flux_df}}{Returns the instance variable flux_df
(tibble::tibble)}

\item{\code{outflux_thr}}{Returns the instance variable outflux_thr.
(numeric)}

\item{\code{setOutflux_thr}}{Sets the instance variable outflux_thr.
(numeric)}

\item{\code{pred_frac}}{Returns the instance variable pred_frac.
(numeric)}

\item{\code{setPred_frac}}{Sets the instance variable pred_frac.
(numeric)}

\item{\code{pred_mat}}{Returns the instance variable pred_mat.
(matrix)}

\item{\code{exclude_vec}}{Returns the instance variable exclude_vec
(character)}

\item{\code{seed}}{Returns the instance variable seed.
(numeric)}

\item{\code{setSeed}}{Sets the instance variable seed.
(numeric)}

\item{\code{iterations}}{Returns the instance variable iterations.
(numeric)}

\item{\code{setIterations}}{Sets the instance variable iterations.
(numeric)}

\item{\code{amv}}{Returns the instance variable amv.
(numeric)}

\item{\code{success}}{Returns the instance variable success.
(logical)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pgu.imputation$new()}}
\item \href{#method-finalize}{\code{pgu.imputation$finalize()}}
\item \href{#method-print}{\code{pgu.imputation$print()}}
\item \href{#method-gatherImputationSites}{\code{pgu.imputation$gatherImputationSites()}}
\item \href{#method-gatherImputationSiteStatistics}{\code{pgu.imputation$gatherImputationSiteStatistics()}}
\item \href{#method-gatherImputationSiteDistribution}{\code{pgu.imputation$gatherImputationSiteDistribution()}}
\item \href{#method-insertImputationSites}{\code{pgu.imputation$insertImputationSites()}}
\item \href{#method-one_hot}{\code{pgu.imputation$one_hot()}}
\item \href{#method-analyzeImputationSites}{\code{pgu.imputation$analyzeImputationSites()}}
\item \href{#method-imputationSiteIdxByFeature}{\code{pgu.imputation$imputationSiteIdxByFeature()}}
\item \href{#method-nanFeatureList}{\code{pgu.imputation$nanFeatureList()}}
\item \href{#method-average_number_of_predictors}{\code{pgu.imputation$average_number_of_predictors()}}
\item \href{#method-detectPredictors}{\code{pgu.imputation$detectPredictors()}}
\item \href{#method-handleImputationSites}{\code{pgu.imputation$handleImputationSites()}}
\item \href{#method-imputeByMedian}{\code{pgu.imputation$imputeByMedian()}}
\item \href{#method-imputeByMean}{\code{pgu.imputation$imputeByMean()}}
\item \href{#method-imputeByExpectationValue}{\code{pgu.imputation$imputeByExpectationValue()}}
\item \href{#method-imputeByMC}{\code{pgu.imputation$imputeByMC()}}
\item \href{#method-imputeByKnn}{\code{pgu.imputation$imputeByKnn()}}
\item \href{#method-imputeByMice}{\code{pgu.imputation$imputeByMice()}}
\item \href{#method-imputeByM5P}{\code{pgu.imputation$imputeByM5P()}}
\item \href{#method-imputationSiteHeatMap}{\code{pgu.imputation$imputationSiteHeatMap()}}
\item \href{#method-featureBarPlot}{\code{pgu.imputation$featureBarPlot()}}
\item \href{#method-featureBoxPlotWithSubset}{\code{pgu.imputation$featureBoxPlotWithSubset()}}
\item \href{#method-featurePlot}{\code{pgu.imputation$featurePlot()}}
\item \href{#method-fluxPlot}{\code{pgu.imputation$fluxPlot()}}
\item \href{#method-clone}{\code{pgu.imputation$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new \code{pgu.imputation} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$new(
  seed = 42,
  iterations = 4,
  imputationAgent = "none",
  nNeighbors = 3,
  pred_frac = 1,
  outflux_thr = 0.5
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{seed}}{Initially sets the instance variable seed.
Default is 42.
(integer)}

\item{\code{iterations}}{Initially sets the instance variable iterations.
Default is 4.
(integer)}

\item{\code{imputationAgent}}{Initially sets the instance variable imputationAgent.
Default is "none".
Options are: ""none", "median", "mean", "expValue", "monteCarlo", "knn", "pmm", "cart", "randomForest", "M5P".
(string)}

\item{\code{nNeighbors}}{Initially sets the instance variable nNeighbors.
(integer)}

\item{\code{pred_frac}}{Initially sets the instance variable pred_frac.
(numeric)}

\item{\code{outflux_thr}}{Initially sets the instance fariable outflux_thr}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{pgu.imputation} object.
(pguIMP::pgu.imputation)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates that instance of \code{pgu.imputation} is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a \code{pgu.imputation} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gatherImputationSites"></a>}}
\if{latex}{\out{\hypertarget{method-gatherImputationSites}{}}}
\subsection{Method \code{gatherImputationSites()}}{
Gathers imputation sites from pguIMP's missings and outliers class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$gatherImputationSites(
  missings_df = "tbl_df",
  outliers_df = "tbl_df"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{missings_df}}{Dataframe comprising information about the imputation sites of pguIMP's missings class.
(tibble::tibble)}

\item{\code{outliers_df}}{Dataframe comprising information about the imputation sites of pguIMP's outliers class.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gatherImputationSiteStatistics"></a>}}
\if{latex}{\out{\hypertarget{method-gatherImputationSiteStatistics}{}}}
\subsection{Method \code{gatherImputationSiteStatistics()}}{
Gathers statistical information about imputation sites
The information is stored within the classes instance variable \code{imputationStatistics}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$gatherImputationSiteStatistics(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gatherImputationSiteDistribution"></a>}}
\if{latex}{\out{\hypertarget{method-gatherImputationSiteDistribution}{}}}
\subsection{Method \code{gatherImputationSiteDistribution()}}{
Gathers the distribution of imputation sites within the data frame.
The information is stored within the classes instance variable imputationSiteDistribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$gatherImputationSiteDistribution(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-insertImputationSites"></a>}}
\if{latex}{\out{\hypertarget{method-insertImputationSites}{}}}
\subsection{Method \code{insertImputationSites()}}{
Takes a dataframe, replaces the imputation sites indicated by the instance variable \code{imputationsites} by NA,
and returns the mutated dataframe.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$insertImputationSites(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A mutated version of data_df.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-one_hot"></a>}}
\if{latex}{\out{\hypertarget{method-one_hot}{}}}
\subsection{Method \code{one_hot()}}{
Gathers statistical information about missing values
in one hot format.
The result is stored in the instance variable one_hot_df.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$one_hot(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-analyzeImputationSites"></a>}}
\if{latex}{\out{\hypertarget{method-analyzeImputationSites}{}}}
\subsection{Method \code{analyzeImputationSites()}}{
Takes a dataframe and analyses the imputation sites.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$analyzeImputationSites(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputationSiteIdxByFeature"></a>}}
\if{latex}{\out{\hypertarget{method-imputationSiteIdxByFeature}{}}}
\subsection{Method \code{imputationSiteIdxByFeature()}}{
Returns the position of an attribute's imputation sites within a data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$imputationSiteIdxByFeature(featureName = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{featureName}}{The attribute's name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The postion of the imputation sites.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nanFeatureList"></a>}}
\if{latex}{\out{\hypertarget{method-nanFeatureList}{}}}
\subsection{Method \code{nanFeatureList()}}{
Characterizes each row of the data frame as either \code{complete}
or indicates which attribute are missing within the row.
If multiple attributes' row entries are missing, the row is characterized by \code{multiple}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$nanFeatureList(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of row characteristics.
(character)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-average_number_of_predictors"></a>}}
\if{latex}{\out{\hypertarget{method-average_number_of_predictors}{}}}
\subsection{Method \code{average_number_of_predictors()}}{
Calculates the average number of predictors for a given dataframe and minpuc and mincor variables
using the mice::quickpred routine.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$average_number_of_predictors(
  data_df = "tbl_df",
  minpuc = 0,
  mincor = 0.1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The dataframe to be analyzed
(tibble::tibble)}

\item{\code{minpuc}}{Specifies the minimum threshold for the proportion of usable cases.
(numeric)}

\item{\code{mincor}}{Specifies the minimum threshold against which the absolute correlation in the dataframe is compared.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Average_number_of_predictors.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-detectPredictors"></a>}}
\if{latex}{\out{\hypertarget{method-detectPredictors}{}}}
\subsection{Method \code{detectPredictors()}}{
Identifies possible predictors for each feature.
Analysis results are written to the instance variable pred_mat.
Intermediate analysis results are an influx/outflux dataframe
that is written to the instance variable flux_df and
detect predictors and a list of features that is excluded from
the search for possible predictors that is written to the
instance variable exclude_vec.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$detectPredictors(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The dataframe to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-handleImputationSites"></a>}}
\if{latex}{\out{\hypertarget{method-handleImputationSites}{}}}
\subsection{Method \code{handleImputationSites()}}{
Chooses a cleaning method based upon the instance variable \code{imputationAgent}
and handles the imputation sites in the dataframe.
Returns a cleaned data set.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$handleImputationSites(data_df = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored within this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Cleaned dataframe.
(tibble:tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputeByMedian"></a>}}
\if{latex}{\out{\hypertarget{method-imputeByMedian}{}}}
\subsection{Method \code{imputeByMedian()}}{
Substitutes imputation sites by the median of the respective attribute.
Returns the cleaned dataframe.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$imputeByMedian(data_df = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Cleaned dataframe.
(tibble:tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputeByMean"></a>}}
\if{latex}{\out{\hypertarget{method-imputeByMean}{}}}
\subsection{Method \code{imputeByMean()}}{
Substitutes imputation sites by the aritmertic mean of the respective attribute.
Returns the cleaned dataframe.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$imputeByMean(data_df = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Cleaned dataframe.
(tibble:tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputeByExpectationValue"></a>}}
\if{latex}{\out{\hypertarget{method-imputeByExpectationValue}{}}}
\subsection{Method \code{imputeByExpectationValue()}}{
Substitutes imputation sites by the expectation value of the respective attribute.
Returns the cleaned dataframe.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$imputeByExpectationValue(
  data_df = "tbl_df",
  progress = "Progress"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Cleaned dataframe.
(tibble:tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputeByMC"></a>}}
\if{latex}{\out{\hypertarget{method-imputeByMC}{}}}
\subsection{Method \code{imputeByMC()}}{
Substitutes imputation sites by values generated by a monte carlo simulation.
The procedure runs several times as defined by the instance variable \code{iterations}.
The run with the best result is identified and used for substitution.
Returns the cleaned dataframe.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$imputeByMC(data_df = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Cleaned dataframe.
(tibble:tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputeByKnn"></a>}}
\if{latex}{\out{\hypertarget{method-imputeByKnn}{}}}
\subsection{Method \code{imputeByKnn()}}{
Substitutes imputation sites by predictions of a KNN analysis of the whole dataframe.
Returns the cleaned dataframe.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$imputeByKnn(data_df = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Cleaned dataframe.
(tibble:tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputeByMice"></a>}}
\if{latex}{\out{\hypertarget{method-imputeByMice}{}}}
\subsection{Method \code{imputeByMice()}}{
Substitutes imputation sites by values generated by a different methods of the mice package.
The procedure runs several times as defined by the instance variable \code{iterations}.
The run with the best result is identified and used for substitution.
Returns the cleaned dataframe.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$imputeByMice(data_df, progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Cleaned dataframe.
(tibble:tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputeByM5P"></a>}}
\if{latex}{\out{\hypertarget{method-imputeByM5P}{}}}
\subsection{Method \code{imputeByM5P()}}{
Substitutes imputation sites by predictions of a M5P tree trained on the whole dataframe.
Returns the cleaned dataframe.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$imputeByM5P(data_df = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Cleaned dataframe.
(tibble:tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputationSiteHeatMap"></a>}}
\if{latex}{\out{\hypertarget{method-imputationSiteHeatMap}{}}}
\subsection{Method \code{imputationSiteHeatMap()}}{
Displays the distribution of missing values in form of a heatmap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$imputationSiteHeatMap()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A heatmap plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featureBarPlot"></a>}}
\if{latex}{\out{\hypertarget{method-featureBarPlot}{}}}
\subsection{Method \code{featureBarPlot()}}{
Displays the distribution of an attribute values as histogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$featureBarPlot(data_df = "tbl_df", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{dataframe to be analyzed.
(tibble::tibble)}

\item{\code{feature}}{attribute to be shown.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A histogram.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featureBoxPlotWithSubset"></a>}}
\if{latex}{\out{\hypertarget{method-featureBoxPlotWithSubset}{}}}
\subsection{Method \code{featureBoxPlotWithSubset()}}{
Displays the distribution of an attribute's values as box plot.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$featureBoxPlotWithSubset(
  data_df = "tbl_df",
  feature = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{dataframe to be analyzed.
(tibble::tibble)}

\item{\code{feature}}{attribute to be shown.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A box plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featurePlot"></a>}}
\if{latex}{\out{\hypertarget{method-featurePlot}{}}}
\subsection{Method \code{featurePlot()}}{
Displays the distribution of an attribute's values as a composition of a box plot and a histogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$featurePlot(data_df = "tbl_df", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{dataframe to be analyzed.
(tibble::tibble)}

\item{\code{feature}}{attribute to be shown.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A composite plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fluxPlot"></a>}}
\if{latex}{\out{\hypertarget{method-fluxPlot}{}}}
\subsection{Method \code{fluxPlot()}}{
Displays an influx/outflux plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$fluxPlot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A composite plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.imputation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
