% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguValidator.R
\name{pgu.validator}
\alias{pgu.validator}
\title{pgu.validator}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
Validates that the distribution is not significantly altered by the imputation process.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\details{
Takes two distributions (before and after imputation).
Performs a Wilcoxon-Mann-Whitney U test.
Performs a Kolmogorow-Smirnow test.
}
\author{
Sebastian Malkusch, \email{malkusch@med.uni-frankfurt.de}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{testStatistics_df}}{Returns the instance variable \code{testStatistics_df}.
(tibble::tibble)}

\item{\code{centralMoments_org}}{Returns the instance variable \code{centralMoments_org}
(tibble::tibble)}

\item{\code{centralMoments_imp}}{Returns the instance variable \code{centralMoments_imp}
(tibble::tibble)}

\item{\code{centralMoments_delta}}{Returns the instance variable \code{centralMoments_delta}
(tibble::tibble)}

\item{\code{features}}{Returns the instance variable \code{features}
(character)}

\item{\code{seed}}{Returns the instance variable seed
(integer)}

\item{\code{setSeed}}{Sets the instance variable seed.
(numeric)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pgu.validator$new()}}
\item \href{#method-finalize}{\code{pgu.validator$finalize()}}
\item \href{#method-print}{\code{pgu.validator$print()}}
\item \href{#method-resetValidator}{\code{pgu.validator$resetValidator()}}
\item \href{#method-kolmogorowTestFeature}{\code{pgu.validator$kolmogorowTestFeature()}}
\item \href{#method-wilcoxonTestFeature}{\code{pgu.validator$wilcoxonTestFeature()}}
\item \href{#method-centralMomentsFeature}{\code{pgu.validator$centralMomentsFeature()}}
\item \href{#method-validate}{\code{pgu.validator$validate()}}
\item \href{#method-featurePdf}{\code{pgu.validator$featurePdf()}}
\item \href{#method-featureCdf}{\code{pgu.validator$featureCdf()}}
\item \href{#method-featureVs}{\code{pgu.validator$featureVs()}}
\item \href{#method-featureBoxPlot}{\code{pgu.validator$featureBoxPlot()}}
\item \href{#method-featurePlot}{\code{pgu.validator$featurePlot()}}
\item \href{#method-clone}{\code{pgu.validator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new \code{pgu.validator} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$new(seed = 42)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{seed}}{Set the instance variable \code{seed}.
(integer)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{pgu.validator} object.
(pguIMP::pgu.validator)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates that instance of \code{pgu.validator} is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a \code{pgu.validator} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetValidator"></a>}}
\if{latex}{\out{\hypertarget{method-resetValidator}{}}}
\subsection{Method \code{resetValidator()}}{
Resets instance variables
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$resetValidator()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-kolmogorowTestFeature"></a>}}
\if{latex}{\out{\hypertarget{method-kolmogorowTestFeature}{}}}
\subsection{Method \code{kolmogorowTestFeature()}}{
Performs a comparison between the original and the imputated distribution of a given feature
using a two-sided Kolmorogow-Smirnow test with simulated p-vaue distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$kolmogorowTestFeature(
  org = "numeric",
  imp = "numeric",
  feature = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{org}}{Original data to be analzed.
(numeric)}

\item{\code{imp}}{Imputed data to be analyzed.
(numeric)}

\item{\code{feature}}{Feature name of the analyzed distributions.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
One row dataframe comprising the test results.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wilcoxonTestFeature"></a>}}
\if{latex}{\out{\hypertarget{method-wilcoxonTestFeature}{}}}
\subsection{Method \code{wilcoxonTestFeature()}}{
Performs a comparison between the original and the imputated distribution of a given feature
using a two-sided Wilcoxon/Mann-Whitney test.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$wilcoxonTestFeature(
  org = "numeric",
  imp = "numeric",
  feature = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{org}}{Original data to be analzed.
(numeric)}

\item{\code{imp}}{Imputed data to be analyzed.
(numeric)}

\item{\code{feature}}{Feature name of the analyzed distributions.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
One row dataframe comprising the test results.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-centralMomentsFeature"></a>}}
\if{latex}{\out{\hypertarget{method-centralMomentsFeature}{}}}
\subsection{Method \code{centralMomentsFeature()}}{
Estimates estimates the central moments of the given distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$centralMomentsFeature(values = "numeric", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{Data to be analzed.
(numeric)}

\item{\code{feature}}{Feature name of the analyzed distributions.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
One row dataframe comprising the statistics.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-validate"></a>}}
\if{latex}{\out{\hypertarget{method-validate}{}}}
\subsection{Method \code{validate()}}{
Validates the feature distributions of the original and the imputated dataframe``
using a two-sided Kolmorogow-Smirnow test and a two-sided Wilcoxon/Mann-Whitney test.
The result is stored in the instance variables \code{testStatistics_df}and `distributionStatistics_df`.
Displays the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$validate(
  org_df = "tbl_df",
  imp_df = "tbl_df",
  progress = "Progress"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{org_df}}{Original dataframe to be analzed.
(tibble::tibble)}

\item{\code{imp_df}}{Imputed dataframe to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featurePdf"></a>}}
\if{latex}{\out{\hypertarget{method-featurePdf}{}}}
\subsection{Method \code{featurePdf()}}{
Receives a dataframe and plots the pareto density of the features 'org_pdf' and 'imp_pdf'.
Returns the plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$featurePdf(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{dataframe to be plotted
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 object
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featureCdf"></a>}}
\if{latex}{\out{\hypertarget{method-featureCdf}{}}}
\subsection{Method \code{featureCdf()}}{
Receives a dataframe and plost the feature 'x' against the features 'org_cdf' and 'imp_cdf'.
Returns the plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$featureCdf(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{dataframe to be plotted
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 object
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featureVs"></a>}}
\if{latex}{\out{\hypertarget{method-featureVs}{}}}
\subsection{Method \code{featureVs()}}{
Receives two numeric vectors 'org' and 'imp'. Plots the qq-plot of both vectors.
Returns the plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$featureVs(org = "numeric", imp = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{org}}{Numric vector comprising the original data.
(numeric)}

\item{\code{imp}}{Numeric vector comprising the imputed data.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 object
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featureBoxPlot"></a>}}
\if{latex}{\out{\hypertarget{method-featureBoxPlot}{}}}
\subsection{Method \code{featureBoxPlot()}}{
Receives a dataframe and information about the lloq and uloq and retuns a boxplot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$featureBoxPlot(
  data_df = "tbl_df",
  lloq = "numeric",
  uloq = "numeric",
  feature = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Dataframe to be analyzed
(tibble::tibble)}

\item{\code{lloq}}{lower limit of quantification
(numeric)}

\item{\code{uloq}}{upper limit of quantification
(numeric)}

\item{\code{feature}}{Feature name
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 object
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featurePlot"></a>}}
\if{latex}{\out{\hypertarget{method-featurePlot}{}}}
\subsection{Method \code{featurePlot()}}{
Receives two numeric dataframes 'org_df' and 'imp_df', and a feature name.
Creates a compund plot of the validation results for the given feature..
Returns the plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$featurePlot(
  org_df = "tbl_df",
  imp_df = "tbl_df",
  lloq = "numeric",
  uloq = "numeric",
  impIdx_df = "tbl_df",
  feature = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{org_df}}{Dataframe comprising the original data.
(tibble::tibble)}

\item{\code{imp_df}}{Dataframe comprising the imputed data.
(tibble::tibble)}

\item{\code{lloq}}{lower limit of quantification
(numeric)}

\item{\code{uloq}}{upper limit of quantification
(numeric)}

\item{\code{impIdx_df}}{dataframe comprising information about imputation sites
(tibble::tibble)}

\item{\code{feature}}{Feature name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 object
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.validator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
