% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguNormalizer.R
\name{pgu.normalizer}
\alias{pgu.normalizer}
\title{pgu.normalizer}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
Normalization of data. Part of pguIMP.
}
\details{
Performs a data normalization in order to achieve a standardized version of the dataframe.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch, \email{malkusch@med.uni-frankfurt.de}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{normAgentAlphabet}}{Returns the instance variable normAgentAlphabt.}

\item{\code{normAgent}}{Returns the instance variable normAgent.
(character)}

\item{\code{setNormAgent}}{Sets the instance variable normAgent.
(character)}

\item{\code{features}}{Returns instance variable features.
(character)}

\item{\code{normParameter}}{Returns the instance variable normParameter.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pgu.normalizer$new()}}
\item \href{#method-finalize}{\code{pgu.normalizer$finalize()}}
\item \href{#method-print}{\code{pgu.normalizer$print()}}
\item \href{#method-detectNormParameter}{\code{pgu.normalizer$detectNormParameter()}}
\item \href{#method-scale_data}{\code{pgu.normalizer$scale_data()}}
\item \href{#method-scale_minMax}{\code{pgu.normalizer$scale_minMax()}}
\item \href{#method-scale_minMax_numeric}{\code{pgu.normalizer$scale_minMax_numeric()}}
\item \href{#method-scale_mean}{\code{pgu.normalizer$scale_mean()}}
\item \href{#method-scale_mean_numeric}{\code{pgu.normalizer$scale_mean_numeric()}}
\item \href{#method-scale_zScore}{\code{pgu.normalizer$scale_zScore()}}
\item \href{#method-scale_zScore_numeric}{\code{pgu.normalizer$scale_zScore_numeric()}}
\item \href{#method-rescale_data}{\code{pgu.normalizer$rescale_data()}}
\item \href{#method-rescale_minMax}{\code{pgu.normalizer$rescale_minMax()}}
\item \href{#method-rescale_minMax_numeric}{\code{pgu.normalizer$rescale_minMax_numeric()}}
\item \href{#method-rescale_mean}{\code{pgu.normalizer$rescale_mean()}}
\item \href{#method-rescale_mean_numeric}{\code{pgu.normalizer$rescale_mean_numeric()}}
\item \href{#method-rescale_zScore}{\code{pgu.normalizer$rescale_zScore()}}
\item \href{#method-rescale_zScore_numeric}{\code{pgu.normalizer$rescale_zScore_numeric()}}
\item \href{#method-featureBarPlot}{\code{pgu.normalizer$featureBarPlot()}}
\item \href{#method-featureBoxPlotWithSubset}{\code{pgu.normalizer$featureBoxPlotWithSubset()}}
\item \href{#method-featurePlot}{\code{pgu.normalizer$featurePlot()}}
\item \href{#method-clone}{\code{pgu.normalizer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new \code{pgu.normalizer} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$new(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{pgu.normalizer} object.
(pguIMP::pgu.normalizer)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates that instance of \code{pgu.normalizer} is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a \code{pgu.normalizer} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-detectNormParameter"></a>}}
\if{latex}{\out{\hypertarget{method-detectNormParameter}{}}}
\subsection{Method \code{detectNormParameter()}}{
Resets instance variable \code{normParameter}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$detectNormParameter(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Dataframe to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-scale_data"></a>}}
\if{latex}{\out{\hypertarget{method-scale_data}{}}}
\subsection{Method \code{scale_data()}}{
Scales a tibble using the method defined by the instance variable normAgent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$scale_data(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Dataframe to be scaled
(tible::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A normalized version of the dataframe.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-scale_minMax"></a>}}
\if{latex}{\out{\hypertarget{method-scale_minMax}{}}}
\subsection{Method \code{scale_minMax()}}{
Scales a tibble using min-max normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$scale_minMax(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Dataframe to be scaled
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A min-max normalized version of the dataframe
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-scale_minMax_numeric"></a>}}
\if{latex}{\out{\hypertarget{method-scale_minMax_numeric}{}}}
\subsection{Method \code{scale_minMax_numeric()}}{
Scales a numeric object using min-max normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$scale_minMax_numeric(values = "numeric", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{Values to be scaled. Either a number or a vector
(numeric)}

\item{\code{feature}}{Character to idtentify the proper normalization parameters.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A min-max normalized version of the numeric object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-scale_mean"></a>}}
\if{latex}{\out{\hypertarget{method-scale_mean}{}}}
\subsection{Method \code{scale_mean()}}{
Scales a tibble using mean normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$scale_mean(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Dataframe to be scaled.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A mean normalized version of the dataframe
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-scale_mean_numeric"></a>}}
\if{latex}{\out{\hypertarget{method-scale_mean_numeric}{}}}
\subsection{Method \code{scale_mean_numeric()}}{
Scales a numeric object using mean normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$scale_mean_numeric(values = "numeric", feature = character)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{Values to be scaled. Either a number or a vector
(numeric)}

\item{\code{feature}}{Character to idtentify the proper normalization parameters.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A mean normalized version of the numeric object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-scale_zScore"></a>}}
\if{latex}{\out{\hypertarget{method-scale_zScore}{}}}
\subsection{Method \code{scale_zScore()}}{
Scales a tibble using z-score normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$scale_zScore(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Dataframe to be scaled
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A z-score normalized version of the dataframe
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-scale_zScore_numeric"></a>}}
\if{latex}{\out{\hypertarget{method-scale_zScore_numeric}{}}}
\subsection{Method \code{scale_zScore_numeric()}}{
Scales a numeric object using z-score normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$scale_zScore_numeric(values = "numeric", feature = character)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{Values to be scaled. Either a number or a vector
(numeric)}

\item{\code{feature}}{Character to idtentify the proper normalization parameters.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A z-score normalized version of the numeric object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rescale_data"></a>}}
\if{latex}{\out{\hypertarget{method-rescale_data}{}}}
\subsection{Method \code{rescale_data()}}{
Rescales a tibble using the method defined by the instance variable normAgent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$rescale_data(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Normalized dataframe to be rescaled
(tible::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A rescaled version of the normalized dataframe.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rescale_minMax"></a>}}
\if{latex}{\out{\hypertarget{method-rescale_minMax}{}}}
\subsection{Method \code{rescale_minMax()}}{
Rescales a tibble using min-max normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$rescale_minMax(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Normalized dataframe to be rescaled
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A rescaled version of a min-max normalized dataframe
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rescale_minMax_numeric"></a>}}
\if{latex}{\out{\hypertarget{method-rescale_minMax_numeric}{}}}
\subsection{Method \code{rescale_minMax_numeric()}}{
Rescales a numeric object using min-max normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$rescale_minMax_numeric(values = "numeric", feature = character)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{Normalized values to be rescaled. Either a number or a vector
(numeric)}

\item{\code{feature}}{Character to idtentify the proper normalization parameters.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Rescaled version of min-max normalized numeric object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rescale_mean"></a>}}
\if{latex}{\out{\hypertarget{method-rescale_mean}{}}}
\subsection{Method \code{rescale_mean()}}{
Rescales a tibble using mean normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$rescale_mean(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Normalized dataframe to be rescaled
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A rescaled version of a mean normalized dataframe
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rescale_mean_numeric"></a>}}
\if{latex}{\out{\hypertarget{method-rescale_mean_numeric}{}}}
\subsection{Method \code{rescale_mean_numeric()}}{
Rescales a numeric object using mean normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$rescale_mean_numeric(values = "numeric", feature = character)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{Normalized values to be rescaled. Either a number or a vector
(numeric)}

\item{\code{feature}}{Character to idtentify the proper normalization parameters.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Rescaled version of mean normalized numeric object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rescale_zScore"></a>}}
\if{latex}{\out{\hypertarget{method-rescale_zScore}{}}}
\subsection{Method \code{rescale_zScore()}}{
Rescales a tibble using z-score normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$rescale_zScore(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Normalized dataframe to be rescaled
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A rescaled version of a z-score normalized dataframe
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rescale_zScore_numeric"></a>}}
\if{latex}{\out{\hypertarget{method-rescale_zScore_numeric}{}}}
\subsection{Method \code{rescale_zScore_numeric()}}{
Rescales a numeric object using z-score normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$rescale_zScore_numeric(values = "numeric", feature = character)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{Normalized values to be rescaled. Either a number or a vector
(numeric)}

\item{\code{feature}}{Character to idtentify the proper normalization parameters.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Rescaled version of z-score normalized numeric object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featureBarPlot"></a>}}
\if{latex}{\out{\hypertarget{method-featureBarPlot}{}}}
\subsection{Method \code{featureBarPlot()}}{
Displays the distribution of an attribute values as histogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$featureBarPlot(data_df = "tbl_df", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{dataframe to be analyzed.
(tibble::tibble)}

\item{\code{feature}}{attribute to be shown.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A histogram.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featureBoxPlotWithSubset"></a>}}
\if{latex}{\out{\hypertarget{method-featureBoxPlotWithSubset}{}}}
\subsection{Method \code{featureBoxPlotWithSubset()}}{
Displays the distribution of an attribute's values as box plot.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$featureBoxPlotWithSubset(
  data_df = "tbl_df",
  feature = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{dataframe to be analyzed.
(tibble::tibble)}

\item{\code{feature}}{attribute to be shown.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A box plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featurePlot"></a>}}
\if{latex}{\out{\hypertarget{method-featurePlot}{}}}
\subsection{Method \code{featurePlot()}}{
Displays the distribution of an attribute's values as a composition of a box plot and a histogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$featurePlot(data_df = "tbl_df", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{dataframe to be analyzed.
(tibble::tibble)}

\item{\code{feature}}{attribute to be shown.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A composite plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normalizer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
