/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.colors;

import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectInt;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.objects.PSObjectString;
import net.sf.eps2pgf.ps.resources.colors.ColorManager;
import net.sf.eps2pgf.ps.resources.colors.PSColor;

public class Indexed
extends PSColor {
    public static final PSObjectName FAMILYNAME = new PSObjectName("/Indexed");
    private int hival;
    private double[][] levels;
    private PSColor currentColor;

    public Indexed(PSObject pSObject) throws PSError, ProgramError {
        if (!(pSObject instanceof PSObjectArray)) {
            throw new PSErrorTypeCheck();
        }
        PSObjectArray pSObjectArray = (PSObjectArray)pSObject;
        this.currentColor = ColorManager.autoSetColorSpace(pSObjectArray.get(1));
        this.hival = pSObjectArray.get(2).toInt();
        if (this.hival > 4095) {
            throw new PSErrorRangeCheck();
        }
        PSObject pSObject2 = pSObjectArray.get(3);
        if (pSObject2 instanceof PSObjectString) {
            PSObjectString pSObjectString = pSObjectArray.get(3).toPSString();
            int n = this.currentColor.getNrInputValues();
            if (n * (this.hival + 1) != pSObjectString.length()) {
                throw new PSErrorRangeCheck();
            }
            this.levels = new double[this.hival + 1][n];
            for (int i = 0; i <= this.hival; ++i) {
                for (int j = 0; j < n; ++j) {
                    double d;
                    this.levels[i][j] = d = (double)pSObjectString.get(i * n + j) / 255.0;
                }
            }
        } else {
            throw new PSErrorUnimplemented("Indexed color space with non-string lookup table.");
        }
    }

    public Indexed clone() {
        Indexed indexed;
        try {
            indexed = (Indexed)super.clone();
            indexed.currentColor = this.currentColor.clone();
            indexed.levels = (double[][])this.levels.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            indexed = null;
        }
        return indexed;
    }

    public double getLevel(int n) {
        return this.currentColor.getLevel(n);
    }

    public double[] getCMYK() {
        return this.currentColor.getCMYK();
    }

    public PSObjectArray getColorSpace() {
        PSObjectArray pSObjectArray = new PSObjectArray();
        pSObjectArray.addToEnd(new PSObjectName("Indexed", true));
        pSObjectArray.addToEnd(this.currentColor.getColorSpace());
        pSObjectArray.addToEnd(new PSObjectInt(this.hival));
        try {
            int n = this.currentColor.getNrComponents();
            PSObjectString pSObjectString = new PSObjectString(n * (this.hival + 1));
            for (int i = 0; i <= this.hival; ++i) {
                for (int j = 0; j < n; ++j) {
                    char c = (char)Math.round(this.levels[i][j] * 255.0);
                    pSObjectString.set(i * n + j, c);
                }
            }
            pSObjectArray.addToEnd(pSObjectString);
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            // empty catch block
        }
        return pSObjectArray;
    }

    public PSObjectName getFamilyName() {
        return FAMILYNAME;
    }

    public double getGray() {
        return this.currentColor.getGray();
    }

    public double[] getHSB() {
        return this.currentColor.getHSB();
    }

    public int getNrComponents() {
        return this.currentColor.getNrComponents();
    }

    public int getNrInputValues() {
        return 1;
    }

    public String getPreferredColorSpace() {
        return this.currentColor.getPreferredColorSpace();
    }

    public double[] getRGB() {
        return this.currentColor.getRGB();
    }

    public void setColor(double[] dArray) throws PSError, ProgramError {
        if (dArray.length != 1) {
            throw new PSErrorRangeCheck();
        }
        int n = (int)dArray[0];
        this.currentColor.setColor(this.levels[n]);
    }
}

