% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools.R
\name{createSCHEMA}
\alias{createSCHEMA}
\title{Generate a PostgreSQL CREATE SCHEMA statement, optionally execute the statement if con is not NULL.}
\usage{
createSCHEMA(name, authorization = NULL, if_not_exists = FALSE, con = NULL)
}
\arguments{
\item{name}{A string, the "schema_name" parameter for PostgreSQL CREATE SCHEMA.}

\item{authorization}{A string, the "role_specification" parameter for PostgreSQL CREATE SCHEMA.}

\item{if_not_exists}{TRUE/FALSE, if TRUE, adds "IF NOT EXISTS" to PostgreSQL CREATE SCHEMA statement.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, PostgreSQL CREATE SCHEMA statement; or the results retrieved by DBI::dbSendQuery after executing the statement.
}
\description{
Generate a PostgreSQL CREATE SCHEMA statement, optionally execute the statement if con is not NULL.
}
\examples{
createSCHEMA("dev")
}
