## ----setup, include = FALSE----------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ------------------------------------------------------------------------
library(petro.One)

## ------------------------------------------------------------------------
# provide two different set of keywords to combine as vectors
major  <- c("water injection", "water flooding")
minor  <- c("machine-learning", "intelligent")
lesser <- c("neural network", "SVM", "genetic", "algorithm")

p.df <- join_keywords(major, minor, lesser, get_papers = TRUE)
p.df

## ----rows.print=20-------------------------------------------------------
# provide two different set of keywords to combine as vectors
m  <- c("water injection", "water flooding")
n  <- c("machine-learning", "machine learning", "intelligent")
p  <- c("neural network", "SVM", "genetic")
q  <- c("algorithm")

p.df <- join_keywords(m, n, p, q, get_papers = TRUE)
p.df

## ------------------------------------------------------------------------
# provide two different set of keywords to combine as vectors
major   <- c("waterflooding")
minor   <- c("machine-learning", "artificial intelligence")
lesser  <- c("algorithm")
another <- c("data-mining")
more    <- c("data-driven")

p.df <- join_keywords(major, minor, lesser, another, more, get_papers = TRUE)
p.df

