% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemInformation.R
\name{itemInformation}
\alias{itemInformation}
\title{Item Information.}
\usage{
itemInformation(a = 1, b, c = 0, d = 1, theta)
}
\arguments{
\item{a}{Discrimination parameter (slope).}

\item{b}{Difficulty (severity) parameter (inflection point).}

\item{c}{Guessing parameter (lower asymptote).}

\item{d}{Careless errors parameter (upper asymptote).}

\item{theta}{Person's level on the construct.}
}
\value{
Amount of item information.
}
\description{
Item information in item response theory.
}
\details{
Estimates the amount of information provided by a given item as function of
the item parameters and the person's level on the construct (theta).
}
\examples{
itemInformation(b = 2, theta = -4:4) #1PL
itemInformation(b = 2, a = 1.5, theta = -4:4) #2PL
itemInformation(b = 2, a = 1.5, c = 0.10, theta = -4:4) #3PL
itemInformation(b = 2, a = 1.5, c = 0.10, d = 0.95, theta = -4:4) #4PL

}
\seealso{
\doi{10.1177/0146621613475471}

Other IRT: 
\code{\link{discriminationToFactorLoading}()},
\code{\link{fourPL}()},
\code{\link{reliabilityIRT}()},
\code{\link{standardErrorIRT}()}
}
\concept{IRT}
