% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map2dend}
\alias{map2dend}
\title{Transforming a map into a dendrogram}
\usage{
map2dend(map, mergeoff = 0L)
}
\arguments{
\item{map}{One map. Required.}

\item{mergeoff}{Numeric, offset between chromosomes, to avoid equal heights in dendrogram.
Equal heights lead to problems in cor_bakers_gamma().}
}
\value{
Dendogram object.
}
\description{
Create dendrogram object. The map specific distance are ignored and only the grouping and ordering is maintained.
Allows for comparison of whole map with package 'dendextend'
}
\examples{
data(simTetra)
simTetrageno <- bases2genotypes(simTetra, 4)
rfMat <- calcRec(simTetrageno, 4)
split <- splitChr(rfMat, nchr = 7)
split <- sortLeafs(rfMat, split)
map <- pullMap(rfMat, split = split)   
dend <- map2dend(map)  
plot(dend)
}

