% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_mse.R
\name{performance_mse}
\alias{performance_mse}
\alias{mse}
\title{Mean Square Error of Linear Models}
\usage{
performance_mse(model, verbose = TRUE)

mse(model, verbose = TRUE)
}
\arguments{
\item{model}{A model.}

\item{verbose}{Toggle off warnings.}
}
\value{
Numeric, the mean square error of \code{model}.
}
\description{
Compute mean square error of linear models.
}
\details{
The mean square error is the mean of the sum of squared residuals,
   i.e. it measures the average of the squares of the errors. Lower
   values (closer to zero) indicate better fit.
}
\examples{
data(mtcars)
m <- lm(mpg ~ hp + gear, data = mtcars)
performance_mse(m)

}
