% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/peptider.r
\name{libBuild}
\alias{libBuild}
\title{Build peptide library of k-length sequences according to specified scheme}
\usage{
libBuild(k, libscheme, scale1 = 1, scale2 = 1)
}
\arguments{
\item{k}{length of peptide sequences}

\item{libscheme}{library scheme specifying classes of amino acids according to number of encodings
last class is reserved for stop tags and other amino acids we are not interested in.}

\item{scale1}{Scaling factor for first probs}

\item{scale2}{Scaling factor for second probs}
}
\value{
library and library scheme used
}
\description{
Build peptide library of k-length sequences according to specified scheme
}
\examples{
user_scheme <- data.frame(class=c("A", "B", "C", "Z"),
                          aacid=c("SLR", "AGPTV", "CDEFHIKMNQWY", "*"),
                          c=c(3,2,1,1))
user_library <- libBuild(3, user_scheme)
}

