% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot.pense_fit}
\alias{plot.pense_fit}
\title{Plot Method for Penalized Estimates}
\usage{
\method{plot}{pense_fit}(x, alpha, ...)
}
\arguments{
\item{x}{fitted estimates.}

\item{alpha}{Plot the coefficient path for the fit with the given hyper-parameter value.
If missing of \code{NULL}, the first value in \code{x$alpha} is used.}

\item{...}{currently ignored.}
}
\description{
Plot the coefficient path for fitted penalized elastic net S- or LS-estimates of regression.
}
\examples{
# Compute the PENSE regularization path for Freeny's revenue data
# (see ?freeny)
data(freeny)
x <- as.matrix(freeny[ , 2:5])

regpath <- pense(x, freeny$y, alpha = 0.5)
plot(regpath)

# Extract the coefficients at a certain penalization level
coef(regpath, lambda = regpath$lambda[[1]][[40]])

# What penalization level leads to good prediction performance?
set.seed(123)
cv_results <- pense_cv(x, freeny$y, alpha = 0.5,
                       cv_repl = 2, cv_k = 4)
plot(cv_results, se_mult = 1)

# Extract the coefficients at the penalization level with
# smallest prediction error ...
coef(cv_results)
# ... or at the penalization level with prediction error
# statistically indistinguishable from the minimum.
coef(cv_results, lambda = '1-se')
}
\seealso{
Other functions for plotting and printing: 
\code{\link{plot.pense_cvfit}()},
\code{\link{prediction_performance}()},
\code{\link{summary.pense_cvfit}()}
}
\concept{functions for plotting and printing}
