% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elnet.R
\name{elnet_cv}
\alias{elnet_cv}
\title{Cross-validate Elastic Net}
\usage{
elnet_cv(x, y, alpha, nlambda = 100, lambda, weights, intercept = TRUE,
  cv_k = 10, cv_measure, ncores = getOption("mc.cores", 1L), cl = NULL,
  options = en_options_aug_lars(), lambda_min_ratio, ...)
}
\arguments{
\item{x}{data matrix with predictors}

\item{y}{response vector}

\item{alpha}{controls the balance between the L1 and the L2 penalty.
\code{alpha = 0} is the ridge (L2) penalty, \code{alpha = 1} is
the lasso.}

\item{nlambda}{size of the lambda grid if \code{lambda} is not specified.}

\item{lambda}{a grid of decreasing lambda values.}

\item{weights}{an optional vector of weights to be used in the fitting
process. Should be \code{NULL} or a numeric vector. If non-NULL,
weighted EN is used with weights \code{weights}. See also 'Details'.}

\item{intercept}{should an intercept be estimated?}

\item{cv_k}{number of cross validation folds.}

\item{cv_measure}{function (name) which takes a matrix of residuals and
returns a performance measure for each column.}

\item{ncores, cl}{the number of processor cores or an actual \code{parallel}
cluster. At most \code{cv_k + 1} nodes will be used.}

\item{options}{additional options for the EN algorithm. See
\code{\link{en_options}} for details.}

\item{lambda_min_ratio}{if the lambda grid should be automatically defined,
the ratio of the smallest to the largest lambda value in the grid. The
default is \code{1e-6} if $n < p$, and
\code{1e-5 * 10^floor(log10(p / n))} otherwise.}

\item{...}{additional arguments passed on to \code{\link{elnet}}.}
}
\value{
\item{lambda}{vector of lambda values.}
 \item{status}{integer specifying the exit status of the EN algorithm.}
 \item{message}{explanation of the exit status.}
 \item{coefficients}{matrix of regression coefficients. Each
     column corresponds to the estimate for the lambda value at the same
     index.}
 \item{residuals}{matrix of residuals. Each column corresponds to the
     residuals for the lambda value at the same index.}
 \item{cvres}{data frame with lambda, average cross-validated performance
     and the estimated standard deviation.}
}
\description{
Perform k-fold cross-validation for \code{\link{elnet}}.
}
\examples{
# Generate some dummy data
set.seed(12345)
n <- 30
p <- 15
x <- 1 + matrix(rnorm(n * p), ncol = p)
y <- x \%*\% c(2:5, numeric(p - 4)) + rnorm(n)

x_test <- matrix(rnorm(10 * n * p), ncol = p)
y_test <- drop(x_test \%*\% c(2:5, numeric(p - 4)) + rnorm(n))

# Compute the classical EN and select lambda based on CV
set.seed(1234)
est <- elnet_cv(
    x, y,
    alpha = 0.6,
    nlambda = 100
)

# The optimal lambda according to CV is
est$lambda_opt
plot(est)

# and the RMSPE at this lambda is
sqrt(mean((y_test - predict(est, x_test))^2))
}
\seealso{
\code{\link{elnet}} to compute only the solution path, without
     selecting the optimal penalty parameter using CV.
}
