% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_plot.R
\name{plot.ped}
\alias{plot.ped}
\alias{drawPed}
\alias{plot.pedList}
\alias{plot.list}
\title{Plot pedigree}
\usage{
\method{plot}{ped}(x, draw = TRUE, keep.par = FALSE, ...)

drawPed(alignment, annotation = NULL, scaling = NULL, keep.par = FALSE, ...)

\method{plot}{pedList}(x, ...)

\method{plot}{list}(x, ...)
}
\arguments{
\item{x}{A \code{\link[=ped]{ped()}} object or a list of such.}

\item{draw}{A logical, by default TRUE. If FALSE, no plot is produced, only
the plotting parameters are returned.}

\item{keep.par}{A logical, by default FALSE. If TRUE, the graphical
parameters are not reset after plotting, which may be useful for adding
additional annotation.}

\item{...}{Arguments passed on to the internal plot functions. For a complete
list of parameters, see \link{plotmethods}. The most important ones are
illustrated in the Examples below.}

\item{alignment}{List of alignment details, as returned by \code{\link[=.pedAlignment]{.pedAlignment()}}.}

\item{annotation}{List of annotation details as returned by \code{\link[=.pedAnnotation]{.pedAnnotation()}}.}

\item{scaling}{List of scaling parameters as returned by \code{\link[=.pedScaling]{.pedScaling()}}.}
}
\value{
A list of three lists with various plot details: \code{alignment},
\code{annotation}, \code{scaling}.
}
\description{
This is the main function for plotting pedigrees. Many options are available
for controlling the appearance of pedigree symbols and accompanying labels.
The most important ones are illustrated in the Examples section below; for a
complete overview, see the separate page \link{plotmethods}, which also explains
the plotting procedure in more detail.
}
\details{
The main pedigree layout is calculated with the \code{kinship2} package, see
\link[kinship2:align.pedigree]{kinship2::align.pedigree} for details. Unlike \code{kinship2}, the implementation
here also supports singletons, and plotting pedigrees as DAGs. In addition,
some minor adjustments have been made to improve scaling and avoid unneeded
duplications.

If \code{x} is a list of \code{ped} objects these are plotted next to each other,
vertically centred in the plot window. For finer control, and possibly
nested lists of pedigrees, use \code{\link[=plotPedList]{plotPedList()}}.
}
\examples{

# Singleton
plot(singleton(1))

# Trio
x = nuclearPed(father = "fa", mother = "mo", child = "boy")
plot(x)

#' # Modify margins
plot(x, margins = 6)
plot(x, margins = c(0,0,6,6)) # b,l,t,r

# Larger text and symbols
plot(x, cex = 1.5)

# Enlarge symbols only
plot(x, symbolsize = 1.5)

# Various annotations
plot(x, hatched = "boy", starred = "fa", deceased = "mo", title = "Fam 1")

# Swap spouse order
plot(x, spouseOrder = c("mo", "fa"))

#----- ID labels -----

# Label only some members
plot(x, labs = c("fa", "mo"))

# Label males only
plot(x, labs = males)

# Rename some individuals
plot(x, labs = c(FATHER = "fa", "boy"))

# By default, long names are folded to width ~12 characters
plot(x, labs = c("Very long father's name" = "fa"), margin = 2)

# Folding width may be adjusted ...
plot(x, labs = c("Very long father's name" = "fa"), foldLabs = 6)

# ... or switched off (requires larger margin!)
plot(x, labs = c("Very long father's name" = "fa"), foldLabs = FALSE)

# By default, labels are trimmed for initial/trailing line breaks ...
plot(x, labs = c("\nFA" = "fa"))

# ... but this can be overridden
plot(x, labs = c("\nFA" = "fa"), trimLabs = FALSE)

#----- Colours -----

plot(x, col = c(fa = "red"), fill = c(mo = "green", boy = "blue"))

# Non-black hatch colours are specified with the `fill` argument
plot(x, hatched = labels, fill = c(boy = "red"))

# Use functions to specify colours
plot(x, fill = list(red = leaves, blue = ancestors(x, "boy")))

#----- Symbol line types and widths -----

# Dotted, thick symbols
plot(x, lty = 3, lwd = 4, cex = 2)

# Detailed specification of line types and width
plot(x, lty = list(dashed = founders), lwd = c(boy = 4))

#----- Genotypes -----

x = nuclearPed(father = "fa", mother = "mo", child = "boy") |>
  addMarker(fa = "1/1", boy = "1/2", name = "SNP") |>
  addMarker(boy = "a/b")

# Show genotypes for first marker
plot(x, marker = 1)

# Show empty genotypes for untyped individuas
plot(x, marker = 1, showEmpty = TRUE)

# Markers can also be called by name
plot(x, marker = "SNP")

# Multiple markers
plot(x, marker = 1:2)

#----- Further text annotation -----

# Founder inbreeding is shown by default
xinb = x |> setFounderInbreeding("mo", value = 0.1)
plot(xinb)

# ... but can be suppressed
plot(xinb, fouInb = NULL)

# Text can be placed around and inside symbols
plot(x, textAnnot = list(topright = 1:3, inside = LETTERS[1:3]))

# Use lists to add further options; see `?text()`
plot(x, margin = 2, textAnnot = list(
  topright = list(1:3, cex = 0.8, col = 2, font = 2, offset = 0.1),
  left = list(c(boy = "comment"), cex = 2, col = 4, offset = 2, srt = 20)))

# Exhaustive list of annotation positions
plot(singleton(1), cex = 3, textAnnot = list(top="top", left="left",
  right="right", bottom="bottom", topleft="topleft", topright="topright",
  bottomleft="bottomleft", bottomright="bottomright", inside="inside"))

#----- Special pedigrees -----

# Plot as DAG (directed acyclic graph)
plot(x, arrows = TRUE, title = "DAG")

# Medical pedigree
plot(x, aff = "boy", carrier = "mo")

# Miscarriage
plot(x, miscarriage = "boy", deceased = "boy", labs = founders)

# Twins
x = nuclearPed(children = c("tw1", "tw2", "tw3"))
plot(x, twins = data.frame(id1 = "tw1", id2 = "tw2", code = 1)) # MZ
plot(x, twins = data.frame(id1 = "tw1", id2 = "tw2", code = 2)) # DZ

# Triplets
plot(x, twins = data.frame(id1 = c("tw1", "tw2"),
                           id2 = c("tw2", "tw3"),
                           code = 2))

# Selfing
plot(selfingPed(2))

# Complex pedigree: Quadruple half first cousins
plot(quadHalfFirstCousins())

# Straight legs
plot(quadHalfFirstCousins(), align = c(0,0))

# Lists of multiple pedigree
plot(list(singleton(1), nuclearPed(1), linearPed(2)))

# Use of `drawPed()`
dat = plot(nuclearPed(), draw = FALSE)
drawPed(dat$alignment, dat$annotation, dat$scaling)

}
\seealso{
\code{\link[=plotPedList]{plotPedList()}}, \code{\link[kinship2:plot.pedigree]{kinship2::plot.pedigree()}}. Plot options are
documented in \link{plotmethods}.
}
