% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMutmod.R
\name{setMutmod}
\alias{setMutmod}
\title{Set a mutation model}
\usage{
setMutmod(x, markers = NULL, ..., update = FALSE)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{markers}{A vector of names or indices referring to markers attached to
\code{x}. (Default: All markers.)}

\item{...}{Arguments forwarded to \code{\link[pedmut:mutationModel]{pedmut::mutationModel()}}, e.g., \code{model},
\code{rate}, etc.}

\item{update}{A logical. If TRUE, existing mutation models (if present) are
updated with the parameters specified in \code{...}. If FALSE (default), any
previous models are ignored, and new mutation models are created from the
parameters in \code{...}.}
}
\value{
An object similar to \code{x}.
}
\description{
This function offers a convenient way to set or modify mutation models to
markers attached to a pedigree. It wraps \code{\link[pedmut:mutationModel]{pedmut::mutationModel()}}, which
does the main work of creating the models, but relieves the user from having
to loop through the markers in order to supply the correct alleles and
frequencies for each marker.
}
\details{
Currently, the following models are supported:
\itemize{
\item \code{equal}:  All mutations equally likely; probability \code{1 - rate} of no
mutation
\item \code{proportional}: Mutation probabilities are proportional to the target
allele frequencies
\item \code{onestep}: A simple model for microsatellite markers, in which mutations
are only allowed to the nearest neighbours in the allelic ladder. For
example, '10' may mutate to either '9' or '11' (unless '10' is the lowest
allele, in which case '11' is the only option). Not applicable to loci with
non-integral microvariants.
\item \code{stepwise}: A common model for microsatellite markers. Mutation rates
depend on the step size in the allelic ladder, and also the allelic classes:
integral repeats like '16', versus non-integer microvariants like '16.3'.
\item \code{custom}: Allows any mutation matrix to be provided by the user, in the
\code{matrix} parameter
\item \code{random}: This produces a matrix of random numbers, where each row is
normalised so that it sums to 1
\item \code{trivial}: The identity matrix; no mutations are possible
}
}
\examples{

### Example requires the pedmut package ###

if (requireNamespace("pedmut", quietly = TRUE)){

# A pedigree with 1 empty marker; attach 'equal' mutation model
x = nuclearPed(1) |>
  addMarker() |>
  setMutmod(model = "equal", rate = 0.01)

mutmod(x, 1)

# Update rate (but still "equal" model)
y = setMutmod(x, rate = 0.05, update = TRUE)
mutmod(y, 1)

# Change to stepwise model
z = setMutmod(x, model = "stepwise",
              rate = list(female = 0.01, male = 0.02),
              range = 0.1, rate2 = 1e-6)
mutmod(z, 1)

# Remove mutation model
w = setMutmod(x, model = NULL)
mutmod(w, 1)

}

}
