% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_basic.R
\name{ped_basic}
\alias{ped_basic}
\alias{nuclearPed}
\alias{halfSibPed}
\alias{linearPed}
\alias{cousinPed}
\alias{avuncularPed}
\alias{halfCousinPed}
\alias{ancestralPed}
\alias{selfingPed}
\title{Create simple pedigrees}
\usage{
nuclearPed(nch = 1, sex = 1, father = "1", mother = "2", children = NULL)

halfSibPed(
  nch1 = 1,
  nch2 = 1,
  sex1 = 1,
  sex2 = 1,
  type = c("paternal", "maternal")
)

linearPed(n, sex = 1)

cousinPed(
  degree,
  removal = 0,
  side = c("right", "left"),
  half = FALSE,
  child = FALSE
)

avuncularPed(
  top = c("uncle", "aunt"),
  bottom = c("nephew", "niece"),
  side = c("right", "left"),
  type = c("paternal", "maternal"),
  removal = 1,
  half = FALSE
)

halfCousinPed(degree, removal = 0, side = c("right", "left"), child = FALSE)

ancestralPed(g)

selfingPed(s, sex = 1)
}
\arguments{
\item{nch}{The number of children, by default 1. If \code{children} is not NULL,
\code{nch} is set to \code{length(children)}}

\item{sex}{A vector with integer gender codes (0=unknown, 1=male, 2=female).
In \code{nuclearPed()}, it contains the genders of the children and is recycled
(if necessary) to length \code{nch}. In \code{linearPed()} it also contains the
genders of the children (1 in each generation) and should have length at
most \code{n} (recycled if shorter than this). In \code{selfingPed()} it should be a
single number, indicating the gender of the last individual (the others
must necessarily have gender code 0.)}

\item{father}{The label of the father. Default: "1".}

\item{mother}{The label of the mother. Default: "2".}

\item{children}{A character with labels of the children. Default: "3", "4",
...}

\item{nch1, nch2}{The number of children in each sibship.}

\item{sex1, sex2}{Vectors of gender codes for the children in each sibship.
Recycled (if necessary) to lengths \code{nch1} and \code{nch2} respectively.}

\item{type}{Either "paternal" or "maternal".}

\item{n}{The number of generations, not including the initial founders.}

\item{degree}{A non-negative integer: 0=siblings, 1=first cousins; 2=second
cousins, a.s.o.}

\item{removal}{A non-negative integer. See Details and Examples.}

\item{side}{Either "right" or "left"; the side on which removals should be
added.}

\item{half}{A logical indicating if the relationship should be "half-like".
Default: FALSE.}

\item{child}{A logical: Should an inbred child be added to the two bottom
individuals?}

\item{top, bottom}{Words indicating the gender combination in avuncular
relationships. The first must be either "uncle" or "aunt", while the second
is "nephew" or "niece". Both can be abbreviated.}

\item{g}{A nonnegative integer indicating the number of ancestral generations
to include. The resulting pedigree has \code{2^(g+1)-1} members. The case \code{g = 0} results in a singleton.}

\item{s}{A nonnegative integer indicating the number of consecutive selfings.
The case \code{s = 0} results in a singleton.}
}
\value{
A \code{ped} object.
}
\description{
Utility functions for creating some common pedigree structures.
}
\details{
\code{halfSibPed(nch1, nch2)} produces a pedigree containing two sibships (of
sizes \code{nch1} and \code{nch2}) with the same father, but different mothers. If
maternal half sibs are wanted instead, add \code{type = "maternal"}.

\code{cousinPed(degree = n, removal = k)} creates a pedigree with two \code{n}'th
cousins, \code{k} times removed. By default, removals are added on the right side,
but this can be changed by adding \code{side = left}.

\code{halfCousinPed(...)} is a synonym for \code{cousinPed(..., half = TRUE)}.

\code{avuncularPed()} creates uncle/aunt - nephew/niece pedigrees. The empty call
\code{avuncularPed()} is equivalent to avuncularPed("uncle", "nephew"). Note that
the arguments can be abbreviated, so that e.g. \code{avuncularPed("a", "ni")}
produces an aunt-niece relationship. Grand (and great-grand etc) uncles/aunts
can be produced by specifying \code{removal} greater than 1.

\code{ancestralPed(g)} returns the family tree of a single individual, including
all ancestors \code{g} generations back.

\code{selfingPed(s)} returns a line of \code{s} consecutive selfings.
}
\examples{

# A nuclear family with 2 boys and 3 girls
nuclearPed(5, sex = c(1, 1, 2, 2, 2))

# A straight line of females
linearPed(3, sex = 2)

# Paternal half brothers
halfSibPed()

# Maternal half sisters
halfSibPed(sex1 = 2, sex2 = 2, type = "maternal")

# Larger half sibships: boy and girl on one side; 3 girls on the other
halfSibPed(nch1 = 2, sex = 1:2, nch2 = 3, sex2 = 2)

# Grand aunt:
cousinPed(degree = 0, removal = 2)

# Second cousins once removed.
cousinPed(degree = 2, removal = 1)

# Same, but with the 'removal' on the left side.
cousinPed(2, 1, side = "left")

# A child of half first cousins.
halfCousinPed(degree = 1, child = TRUE)

# The 'family tree' of a person
ancestralPed(g = 2)

}
\seealso{
\code{\link[=ped]{ped()}}, \code{\link[=singleton]{singleton()}}, \link{ped_complex}, \link{ped_subgroups}
}
