% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ed_nbs.R
\name{ed_nbs}
\alias{ed_nbs}
\title{query NBS economic data}
\usage{
ed_nbs(symbol = NULL, freq = NULL, geo_type = NULL, subregion = NULL,
  date_range = "10y", from = NULL, to = Sys.Date(), na_rm = FALSE,
  eng = FALSE)
}
\arguments{
\item{symbol}{symbols of NBS indicators. It is available via \code{ed_nbs_symbol}. Default is NULL.}

\item{freq}{the frequency of NBS indicators, including 'monthly', 'quarterly', 'yearly'. Default is NULL.}

\item{geo_type}{geography type in NBS, including 'nation', 'province', 'city'. Default is NULL.}

\item{subregion}{codes of province or city, which is available via \code{ed_nbs_subregion}. Default is NULL.}

\item{date_range}{date range. Available value includes '1m'-'11m', 'ytd', 'max' and '1y'-'ny'. Default is '10y'.}

\item{from}{the start date. Default is NULL. If it is NULL, then calculate using date_range and end date.}

\item{to}{the end date. Default is the current date.}

\item{na_rm}{logical. Whether to remove missing values from datasets. Default is FALSE.}

\item{eng}{logical. The language of the query results is in English or in Chinese Default is FALSE.}
}
\description{
\code{ed_nbs} provides an interface to query economic data from National Bureau of Statistics of China (NBS, \url{https://www.stats.gov.cn/}).
}
\examples{
\dontrun{
# query NBS data without setting any parameters
dt = ed_nbs()

# specify paratmeters
dt1 = ed_nbs(geo_type='nation', freq='quarterly', symbol='A010101')
# or using 'n'/'q' represents 'nation'/'quarterly'
dt2 = ed_nbs(geo_type='n', freq='q', symbol='A010101')


# query data in one province
dt3 = ed_nbs(geo_type='province', freq='quarterly', 
  symbol='A010101', subregion='110000')
  
# query data in all province
dt4 = ed_nbs(geo_type='province', freq='quarterly', 
  symbol='A010101', subregion='all')
}

}
