% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_stock_adj.R
\name{md_stock_adjust}
\alias{md_stock_adjust}
\title{adjust stock price for split and dividend}
\usage{
md_stock_adjust(dt, adjust = FALSE, forward = TRUE, ...)
}
\arguments{
\item{dt}{a list/dataframe of time series datasets that didnt adjust for split or dividend.}

\item{adjust}{whether to adjust the OHLC prices, defaults to FALSE. If it is NULL, return the original data; if it is FALSE, create close_adj or change_pct column if not exist; if it is TRUE, adjust all open, high, low, close columns. The adjustment is based on the cumulative products of close/close_prev.}

\item{forward}{forward adjust or backward adjust, defaults to TRUE.}

\item{...}{Additional parameters.}
}
\description{
\code{md_stock_adjust} adjusts the open, high, low and close stock prices for split and dividend.
}
\examples{
\donttest{
data("dt_banks")

dtadj1 = md_stock_adjust(dt_banks, adjust = FALSE)
dtadj2 = md_stock_adjust(dt_banks, adjust = TRUE)
}
}
