#' Pedometric Tools and Techniques
#' 
#' This package contains functions to employ many of the tools and techniques
#' used in
#' the field of pedometrics (see http://en.wikipedia.org/wiki/Pedometrics for
#' definition of pedometrics). These functions were developed to fulfil the
#' demands created by the PhD research project (2012-2016) entitled
#' \dQuote{Contribution to the Construction of Models for Predicting Soil
#' Properties}, developed by Alessandro Samuel-Rosa under the supervision of 
#' Dr Lúcia HC Anjos (Universidade Federal Rural do Rio de Janeiro, Brazil), 
#' Dr Gustavo M Vasques (Embrapa Solos, Brazil), and Dr Gerard B M Heuvelink
#' (ISRIC - World Soil Information, the Netherlands). The project is supported 
#' by CAPES, Minitério da Educação, Brasília - DF 70040-020, Brazil, process 
#' ID BEX 11677/13-9. Several functions simply 
#' extend the functionalities of other functions commonly used for the analysis
#' of pedometric data. It should be noted that changes are likely to occur quite
#' often and the use of this package as a dependency for other packages is
#' strongly
#' discouraged.
#' 
#' \tabular{ll}{
#' Package: \tab pedometrics\cr
#' Type:    \tab Package    \cr
#' Version: \tab 0.6-3      \cr
#' Date:    \tab 2015-07-28 \cr
#' License: \tab GPL (>= 2) \cr
#' }
#' 
#' @name pedometrics-package
#' @aliases pedometrics-package pedometrics
#' @docType package
#' @author Author and Maintainer: Alessandro Samuel-Rosa
#' \email{alessandrosamuelrosa@@gmail.com}
#' @useDynLib pedometrics
NULL
