% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cont2cat.R
\name{cont2cat}
\alias{cont2cat}
\title{Continuous to categorical}
\usage{
cont2cat(x, breaks)
}
\arguments{
\item{x}{Vector, data frame or matrix with the continuous data to be
converted into categorical data.}

\item{breaks}{Vector or list with the lower and upper limits to be used to
break the continuous data into classes.}
}
\value{
A vector, data frame, or matrix, depending on the class of \code{x}.
}
\description{
Convert continuous data (numeric) into categorical data (factor or integer).
}
\details{
Breaks must be a vector if \code{x} is a vector, but a list if \code{x} is a
data frame or matrix. Using a list allows breaking the data into a different
number of classes.
}
\examples{
require(Hmisc)
# Matrix
x <- c(1:10)
x <- cbind(x, x)
breaks <- list(c(1, 2, 4, 8, 10), c(1, 5, 10))
y <- cont2cat(x, breaks)
y
# Data frame
x <- c(1:10)
x <- data.frame(cbind(x, x))
breaks <- list(c(1, 2, 4, 8, 10), c(1, 5, 10))
y <- cont2cat(x, breaks)
y
# Vector
x <- c(1:10)
breaks <- c(1, 2, 4, 8, 10)
y <- cont2cat(x, breaks)
y
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
\seealso{
\code{\link[Hmisc]{cut2}}
}

