#' Pediatric Growth Standard Distribution Functions
#'
#' Growth standards based on data from the Centers for Disease Control and the
#' World Health Organization.
#'
#' @section Notes: CDC Recommends using WHO growth charts for infants and
#' children ages 0 to 2 years of age in the U.S. and CDC growth charts to
#' monitor growth for children age 2 years and older in the U.S.
#'
#' @param q a vector of quantiles
#' @param p a vector of probabilities
#' @param male integer value, 1 = male, 0 = female
#' @param age numeric age, in months
#' @param length,height in centimeters
#' @param source a character string denoting the data source providing the
#' parameters needed for the estimate.  Valid values are "CDC" and "WHO".  This
#' can be set explicitly, or by using the \code{pedbp_pgs_source} option.
#' @param ... pass through
#'
#' @return
#' \code{p_} method return values from the estimated distribution function.
#'
#' \code{q_} methods return values from the estimated quantile function.
#'
#' \code{z_} methods return standard scores.
#'
#' @references
#' \url{https://www.cdc.gov/growthcharts/percentile_data_files.htm},
#' \url{https://www.who.int/tools/child-growth-standards/standards}
#'
#' @seealso \itemize{
#' \item Distribution functions:
#'   \itemize{
#'     \item \code{\link{bmi_for_age}}
#'     \item \code{\link{head_circumference_for_age}}
#'     \item \code{\link{height_for_age}}
#'     \item \code{\link{length_for_age}}
#'     \item \code{\link{weight_for_age}}
#'     \item \code{\link{weight_for_length}}
#'     \item \code{\link{weight_for_height}}
#'   }
#' \item Plotting functions:
#'   \itemize{
#'     \item \code{\link{gs_chart}}
#'     \item \code{\link{gs_cdf}}
#'   }
#' \item Vignette:
#'   \itemize{
#'     \item \code{vignette(topic = "growth-standards", package = "pedbp")}
#'   }
#' }
#'
#' @name growth-standards
NULL
