% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lwuf.R
\name{add_lwuf}
\alias{add_lwuf}
\title{Add Estimates of Leader Willingness to Use Force to Leader-Year Data}
\usage{
add_lwuf(data, keep)
}
\arguments{
\item{data}{a leader-year or leader dyad-year data frame as generated in \pkg{peacesciencer}}

\item{keep}{an optional argument, specified as a character vector, of the variables from the \code{lwuf} data frame
the user wants in their data. See the \code{lwuf} data and its documentation for more. If the argument is unspecified,
the function will return all measures of leader willingness to use force as generated by Carter and Smith.}
}
\value{
\code{add_lwuf()} takes a leader-year or leader-dyad-year data
frame and adds estimates of leader willingness to use force, as
generated by Carter and Smith (2020).
}
\description{
\code{add_lwuf()} allows you to add estimates of leader
willingness to use force to leader-year data or leader-dyad-year data.
}
\details{
See \code{lwuf} for more information, but I'll copy-paste it here
too.

The letter published by Carter and Smith (2020) contains more information
as to what these thetas refer. The "M1" theta is a variation of the standard
Rasch model from the boilerplate information in the LEAD data. The authors
consider this to be "theoretically relevant" or "risk-related" as these all
refer to conflict or risk-taking. The "M2" theta expands on "M1" by
including political orientation and psychological characteristics. "M3" and
"M4" expand on "M1" and "M2" by considering all 36 variables in the LEAD
data.

The authors construct and include all these measures, though their analyses
suggest "M2" is the best-performing measure. You should probably consider
using \code{theta2_mean} as your default estimate of leader willingness
to use force in leader-year analyses.
}
\examples{

\donttest{
# just call `library(tidyverse)` at the top of the your script
library(magrittr)

create_leaderyears() \%>\% add_lwuf()
}

}
\references{
Carter, Jeff and Charles E. Smith, Jr. 2020. "A Framework for Measuring Leaders' Willingness
to Use Force." \emph{American Political Science Review} 114(4): 1352--1358.
}
\author{
Steven V. Miller
}
