% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdynmc_estFct.R
\name{pdynmc}
\alias{pdynmc}
\title{Generalized Method of Moments (GMM) Estimation of Linear Dynamic Panel Data
   Models.}
\usage{
pdynmc(
  dat = NULL,
  varname.i = NULL,
  varname.t = NULL,
  use.mc.diff = NULL,
  use.mc.lev = NULL,
  use.mc.nonlin = NULL,
  use.mc.nonlinAS = NULL,
  inst.collapse = FALSE,
  inst.stata = FALSE,
  include.y,
  varname.y = NULL,
  lagTerms.y = NULL,
  maxLags.y = NULL,
  include.x = FALSE,
  varname.reg.end = NULL,
  lagTerms.reg.end = NULL,
  maxLags.reg.end = NULL,
  varname.reg.pre = NULL,
  lagTerms.reg.pre = NULL,
  maxLags.reg.pre = NULL,
  varname.reg.ex = NULL,
  lagTerms.reg.ex = NULL,
  maxLags.reg.ex = NULL,
  inst.reg.ex.expand = TRUE,
  include.x.instr = FALSE,
  varname.reg.instr = NULL,
  include.x.toInstr = FALSE,
  varname.reg.toInstr = NULL,
  fur.con = FALSE,
  fur.con.diff = NULL,
  fur.con.lev = NULL,
  varname.reg.fur = NULL,
  lagTerms.reg.fur = NULL,
  include.dum = FALSE,
  dum.diff = NULL,
  dum.lev = NULL,
  varname.dum = NULL,
  col_tol = 0.65,
  w.mat = "iid.err",
  w.mat.stata = FALSE,
  std.err = "corrected",
  estimation = "iterative",
  max.iter = 100,
  iter.tol = 0.01,
  inst.thresh = NULL,
  opt.meth = "BFGS",
  hessian = FALSE,
  optCtrl = list(kkt = FALSE, kkttol = .Machine$double.eps^(1/3), kkt2tol =
    .Machine$double.eps^(1/3), starttests = TRUE, dowarn = TRUE, badval = (0.25) *
    .Machine$double.xmax, usenumDeriv = FALSE, reltol = 1e-12, maxit = 200, trace = TRUE,
    follow.on = FALSE, save.failures = TRUE, maximize = FALSE, factr = 1e+07, pgtol = 0,
    all.methods = FALSE),
  custom.start.val = FALSE,
  start.val = NULL,
  start.val.lo = -1,
  start.val.up = 1,
  seed.input = 42
)
}
\arguments{
\item{dat}{A dataset.}

\item{varname.i}{The name of the cross-section identifier.}

\item{varname.t}{The name of the time-series identifier.}

\item{use.mc.diff}{A logical variable indicating whether moment conditions from
equations in differences (i.e. instruments in levels) should be used.}

\item{use.mc.lev}{A logical variable indicating whether moment conditions from
equations in levels (i.e. instruments in differences) should be used.}

\item{use.mc.nonlin}{A logical variable indicating whether nonlinear (quadratic)
moment conditions should be used.}

\item{use.mc.nonlinAS}{A logical variable indicating whether only the nonlinear
(quadratic) moment conditions in the form proposed by
\insertCite{AhnSch1995;textual}{pdynmc} should be used (is set to `TRUE`
when nonlinear moment conditions are employed).}

\item{inst.collapse}{A logical variable indicating whether to collapse the set
of moment conditions as proposed by \insertCite{Roo2009note}{pdynmc}
(defaults to `FALSE`).}

\item{inst.stata}{A logical variable indicating whether to use the moment
conditions from equations in levels as in Stata implementations xtabond2
\insertCite{Roo2018xtabond2;textual}{pdynmc} and xtdpdgmm
\insertCite{Kri2019;textual}{pdynmc}.}

\item{include.y}{A logical variable indicating whether instruments should be
derived from the lags of the dependent variable.}

\item{varname.y}{A character string denoting the name of the dependent variable
in the dataset.}

\item{lagTerms.y}{An integer indicating the number of lags of the dependent
variable. Note that setting `lagTerms.y` to zero excludes the dependent
variable from the right-hand-side of the model specification.}

\item{maxLags.y}{An integer indicating the maximum number of lags of the
dependent variable from which instruments should be derived.}

\item{include.x}{A logical variable indicating whether instruments should be
derived from the covariates. Setting the argument to `TRUE` requires
specifying whether the covariates are endogenous, predetermined, or
(strictly) exogenous (defaults to `FALSE`).}

\item{varname.reg.end}{One or more character strings denoting the covariate(s)
in the dataset to be treated as endogenous (defaults to `NULL`).}

\item{lagTerms.reg.end}{One or more integers indicating the number of lags of
the endogenous covariate(s). One integer per covariate needs to be given
in the same order as the covariate names (defaults to `NULL`).}

\item{maxLags.reg.end}{One or more integers indicating the maximum number of
lags of the endogenous covariate(s) used for deriving instruments.}

\item{varname.reg.pre}{One or more character strings denoting the covariate(s)
in the dataset to be treated as predetermined (defaults to `NULL`).}

\item{lagTerms.reg.pre}{One or more integers indicating the number of lags of
the predetermined covariate(s).}

\item{maxLags.reg.pre}{One or more integers indicating the maximum number of
lags of the predetermined covariate(s) used for deriving instruments. One
integer per covariate needs to be given in the same order as the covariate
names (defaults to `NULL`).}

\item{varname.reg.ex}{One or more character strings denoting the covariate(s)
in the dataset to be treated as (strictly) exogenous (defaults to `NULL`).}

\item{lagTerms.reg.ex}{One or more integers indicating the number of lags of
the (strictly) exogenous covariate(s). One integer per covariate needs to
be given in the same order as the covariate name (defaults to `NULL`).}

\item{maxLags.reg.ex}{One or more integers indicating the maximum number of
lags of the (strictly) exogenous covariate(s) used for deriving instruments.}

\item{inst.reg.ex.expand}{A logical variable that allows for using all past,
present, and future observations of `varname.reg.ex` to derive instruments
(defaults to `TRUE`). If set to `FALSE`, only past and present time periods
are used to derive instruments.}

\item{include.x.instr}{A logical variable that allows to include additional
IV-type instruments (i.e., include covariates which are used as instruments
but for which no parameters are estimated; defaults to `FALSE`).}

\item{varname.reg.instr}{One or more character strings denoting the covariate(s)
in the dataset treated as instruments in estimation (defaults to `NULL`).
Note that the instrument type needs to be specified by including the names
of the covariate(s) in any of the arguments `varname.reg.end`,
`varname.reg.pre`, or `varname.reg.ex`.}

\item{include.x.toInstr}{A logical variable that allows to instrument covariate(s)
(i.e., covariates which are not used as instruments but for which parameters
are estimated; defaults to `FALSE`).}

\item{varname.reg.toInstr}{One or more character strings denoting the covariate(s)
in the dataset to be instrumented (defaults to `NULL`). Note that the names of
the covariate(s) should not be included in any other function argument.}

\item{fur.con}{A logical variable indicating whether further control variables
(covariates) are included (defaults to `FALSE`).}

\item{fur.con.diff}{A logical variable indicating whether to include further
control variables in equations from differences (defaults to `NULL`).}

\item{fur.con.lev}{A logical variable indicating whether to include further
control variables in equations from level (defaults to `NULL`).}

\item{varname.reg.fur}{One or more character strings denoting covariate(s) in
the dataset to treat as further controls (defaults to `NULL`).}

\item{lagTerms.reg.fur}{One or more integers indicating the number of lags of
the further controls. One integer per further control needs to be given in
the same order as the corresponding variable names (defaults to `NULL`).}

\item{include.dum}{A logical variable indicating whether dummy variables for
the time periods are included (defaults to `FALSE`).}

\item{dum.diff}{A logical variable indicating whether dummy variables are
included in the equations in first differences (defaults to `NULL`).}

\item{dum.lev}{A logical variable indicating whether dummy variables are
included in the equations in levels (defaults to `NULL`).}

\item{varname.dum}{One or more character strings from which time dummies should
be derived (can be different from varname.t; defaults to `NULL`).}

\item{col_tol}{A numeric variable in [0,1] indicating the absolute correlation
threshold for collinearity checks (columns are omitted when pairwise
correlations are above the threshold; defaults to 0.65).}

\item{w.mat}{One of the character strings c(`"iid.err"`, `"identity"`,
`"zero.cov"`) indicating the type of weighting matrix to use (defaults to
`"iid.err"`).}

\item{w.mat.stata}{A logical variable that slightly adjusts the weighting
matrix according to the Stata function xtdpdgmm (defaults to `FALSE`).}

\item{std.err}{One of the character strings c(`"corrected"`, `"unadjusted"`,
 `"dbl.corrected"`).
 The second and third options compute corrected standard error according
 to \insertCite{Win2005;textual}{pdynmc} and
 \insertCite{HwangKangLee2020;textual}{pdynmc}, respectively
(defaults to `"corrected"`).}

\item{estimation}{One of the character strings c(`"onestep"`, `"twostep"`,
`"iterative"`). Denotes the number of iterations of the parameter procedure
(defaults to `"twostep"`).}

\item{max.iter}{An integer indicating the maximum number of iterations
(defaults to `NULL`; if estimation is set to `"iterative"`, `max.iter`
defaults to 100).}

\item{iter.tol}{A numeric variable in [0,1] indicating the tolerance for
determining convergence of the iterative approach (defaults to `NULL`;
if estimation is set to `"iterative"`, iter.tol defaults to 0.01).}

\item{inst.thresh}{An integer denoting above which instrument count a
generalized inverse is used to invert the weighting matrix (defaults to
`NULL`).}

\item{opt.meth}{A character string denoting the numerical optimization procedure.
When no nonlinear moment conditions are employed in estimation, closed form
estimates can be computed by setting the argument to `"none"` (defaults to
`"BFGS"`; for details on the further available optimizers see the
documentation of package \pkg{optimx}).}

\item{hessian}{A logical variable indicating if the hessian matrix should be
approximated in optimization (defaults to `FALSE`).}

\item{optCtrl}{A list of arguments that are passed to \pkg{optimx}.
For details on the arguments and the available options see the package
documentation.}

\item{custom.start.val}{A logical variable indicating whether prespecified
starting values for the parameters are provided by the user (defaults to
`FALSE`; if set to `TRUE`, starting values need to be provided via argument
`start.val`).}

\item{start.val}{A vector of numeric variables denoting the starting values
for the parameter vector for numeric optimization (defaults to `NULL`).}

\item{start.val.lo}{A numeric variable denoting the lower limit for drawing
starting values with uniform density (defaults to -1; ignored if
`custom.start.val` is set to `TRUE`).}

\item{start.val.up}{A numeric variable denoting the lower limit for drawing
starting values with uniform density (defaults to 1; ignored if
`custom.start.val` is set to `TRUE`).}

\item{seed.input}{An integer used as seed for drawing starting values (defaults
to 42; required if custom.start.val is set to `FALSE`).}
}
\value{
An object of class `pdynmc` with the following elements:

\item{coefficients}{a vector containing the coefficient estimates}
\item{data}{a list of elements on which computation of the model fit is based}
\item{dep.clF}{a list of vectors containing the dependent variable for the
   cross-sectional observations}
\item{dat.clF}{a list of matrices containing the covariates for the
   cross-sectional observations}
\item{w.mat}{a list of weighting matrices for the different estimation steps}
\item{H_i}{a matrix used to create the weighting matrix for the first estimation
   step}
\item{par.optim}{a list of vectors containing the parameter estimates obtained
   from numerical optimization for the estimation steps}
\item{ctrl.optim}{a list of control parameters used in numerical optimization for
   the estimation steps}
\item{par.clForm}{a list of vectors containing the parameter estimates obtained
   from the closed form for the estimation steps}
\item{iter}{a scalar denoting the number of iteration steps carried out to
   obtain parameter estimates}
\item{fitted.values}{a list for each estimation step that contains a list of
   vectors of fitted values for each cross-sectional observation}
\item{residuals}{a list for each estimation step that contains a list of vectors
   of residuals for each cross-sectional observation}
\item{vcov}{a list of matrices containing the variance covariance matrix of the
   parameter estimates for each estimation step}
\item{stderr}{a list of vectors containing the standard errors of the parameter
   estimates for each estimation step}
\item{zvalue}{a list of vectors containing the z scores for the parameter
   estimates for each estimation step}
\item{pvalue}{a list of vectors containing the p-values for the parameter
   estimates for each estimation step}

It has `case.names`, `coef`, `dum.coef`, `fitted`, `model.matrix`, `ninst`,
   `nobs`, `optimIn`, `plot`, `print`,`residuals`, `summary`, `variable.names`,
   `vcov`, and `wmat` methods.
}
\description{
\code{pdynmc} fits a linear dynamic panel data model based on moment
   conditions with the Generalized Method of Moments (GMM).
}
\details{
The function estimates a linear dynamic panel data model of the form
   \deqn{y_{i,t} = y_{i,t-1} \rho_1 + \boldsymbol{x}_{i,t}' \boldsymbol{\beta} + a_i + \varepsilon_{i,t}}
   where \eqn{y_{i,t-1}} is the lagged dependent variable, \eqn{\rho_1} is
   the lag parameter, \eqn{\boldsymbol{x}_{i,t}} are further covariates,
   \eqn{\boldsymbol{\beta}} are the corresponding parameters, \eqn{a_i}
   is an unobserved individual specific effect, and
   \eqn{\varepsilon_{i,t}} is an idiosyncratic remainder component. The
   model structure accounts for unobserved individual specific heterogeneity
   and dynamics. Note that the specification given above is simplified for
   illustatory purposes and more general lag structures are allowed in
   \code{pdynmc}.

   Estimation of the model parameters in \code{pdynmc} is based on
   moment conditions with the generalized method of moments (GMM). Linear
   dynamic panel data models  The moment conditions employed in estimation can be linear and
   nonlinear in parameters and estimation is carried out iteratively. In case
   only linear moment conditions are used in estimation, closed form solutions
   can be for computing parameter estimates -- while when nonlinear moment
   conditions are employed, parameter estimation relies on numerical
   optimization of the objective function.

   `pdynmc` provides an implementation of some of the functionality available
   in the Stata library xtdpdgmm \insertCite{Kri2019;textual}{pdynmc} and allows
   for `"onestep"`, `"twostep"`, and `"iterative"` GMM estimation based on the
   moment conditions of \insertCite{HolNewRos1988;textual}{pdynmc},
   \insertCite{AreBov1995;textual}{pdynmc}, and
   \insertCite{AhnSch1995;textual}{pdynmc}. Standard error corrections
   according to \insertCite{Win2005;textual}{pdynmc} and
   \insertCite{HwangKangLee2020;textual}{pdynmc} are available.
   For further details, please see
   \insertCite{FriPuaSch2019c;textual}{pdynmc}.
}
\examples{
## Load data
data(ABdata, package = "pdynmc")
dat <- ABdata
dat[,c(4:7)] <- log(dat[,c(4:7)])
dat <- dat[c(1:140), ]

## Code example
m1 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
         use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = FALSE,
         include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
         fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
         varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
         include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
         w.mat = "iid.err", std.err = "corrected", estimation = "onestep",
         opt.meth = "none")
summary(m1)

\donttest{
## Load data
 data(ABdata, package = "pdynmc")
 dat <- ABdata
 dat[,c(4:7)] <- log(dat[,c(4:7)])

## Arellano and Bond (1991) estimation in Table 4, column (a1)
 m1 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
         use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = FALSE,
         include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
         fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
         varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
         include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
         w.mat = "iid.err", std.err = "corrected", estimation = "onestep",
         opt.meth = "none")
 summary(m1)

## Arellano and Bond (1991) estimation in Table 4, column (a2)
 m2 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
         use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = FALSE,
         include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
         fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
         varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
         include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
         w.mat = "iid.err", std.err = "corrected", estimation = "twostep",
         opt.meth = "none")
 summary(m2)

## Arellano and Bond (1991) twostep estimation extended by nonlinear moment
## conditions
 m3 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
         use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = TRUE,
         include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
         fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
         varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
         include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
         w.mat = "iid.err", std.err = "corrected", estimation = "twostep",
         opt.meth = "BFGS")
 summary(m3)

## Arellano and Bond (1991) iterative estimation extended by nonlinear moment
## conditions
 m4 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
         use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = TRUE,
         include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
         fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
         varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
         include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
         w.mat = "iid.err", std.err = "corrected", estimation = "iterative",
         max.iter = 4, opt.meth = "BFGS")
 summary(m4)

## Arellano and Bond (1991) twostep estimation extended by linear moment
## conditions from equations in levels
 m5 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
         use.mc.diff = TRUE, use.mc.lev = TRUE, use.mc.nonlin = FALSE,
         include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
         fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
         varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
         include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
         w.mat = "iid.err", std.err = "corrected", estimation = "twostep",
         opt.meth = "none")
 summary(m5)
}


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{wald.fct}} for Wald tests,
\code{\link{jtest.fct}} for the Hansen J test, and
\code{\link{mtest.fct}} for serial correlation tests.
\code{\link[optimx]{optimx}} for details on alternative routines and options
   for numerical optimization
}
\author{
Markus Fritsch
}
