% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{lm_coefficients}
\alias{lm_coefficients}
\title{Get coefficients of linear regression model}
\usage{
lm_coefficients(data, formula, each = TRUE)
}
\arguments{
\item{data}{A data frame containing the response variable and predictors.}

\item{formula}{A formula specifying the structure of the linear regression model.}

\item{each}{each variable do a lm or whole multi-lm}
}
\value{
coefficients The coefficients of the linear regression model.
}
\description{
This function fits a linear regression model using the given data and formula, and returns the coefficients.
}
\examples{
data <- data.frame(
    response = c(2, 4, 6, 7, 9),
    x1 = c(1, 2, 3, 4, 5),
    x2 = c(2, 3, 6, 8, 9),
    x3 = c(3, 6, 5, 12, 12)
)
coefficients_df <- lm_coefficients(data, response ~ x1 + x2 + x3)
print(coefficients_df)
plot(coefficients_df)
}
