% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_linear_combo.R
\name{model_combo}
\alias{model_combo}
\title{Model a linear combination of a set of phenotypes using PCSS}
\usage{
model_combo(formula, phi, n, means, covs, ...)
}
\arguments{
\item{formula}{an object of class \code{formula} whose dependent variable is
a series of variables joined by \code{+} operators. \code{model_combo}
will treat a principal component score of those variables as the actual
dependent variable. All model terms must be accounted for in \code{means}
and \code{covs}.}

\item{phi}{named vector of linear weights for each variable in the
dependent variable in \code{formula}.}

\item{n}{sample size.}

\item{means}{named vector of predictor and response means.}

\item{covs}{named matrix of the covariance of all model predictors and the
responses.}

\item{...}{additional arguments}
}
\value{
an object of class \code{"pcsslm"}.

  An object of class \code{"pcsslm"} is a list containing at least the 
  following components:
    \item{call}{the matched call}
    \item{terms}{the \code{terms} object used}
    \item{coefficients}{a \eqn{p x 4} matrix with columns for the 
      estimated coefficient, its standard error, t-statistic and
      corresponding (two-sided) p-value.}
    \item{sigma}{the square root of the estimated variance of the random
      error.}
    \item{df}{degrees of freedom, a 3-vector \eqn{p, n-p, p*}, the
      first being the number of non-aliased coefficients, the last being
      the total number of coefficients.}
    \item{fstatistic}{a 3-vector with the value of the F-statistic with its
      numerator and denominator degrees of freedom.}
    \item{r.squared}{\eqn{R^2}, the 'fraction of variance explained by the 
      model'.}
    \item{adj.r.squared}{the above \eqn{R^2} statistic \emph{'adjusted'},
      penalizing for higher \eqn{p}.}
    \item{cov.unscaled}{a \eqn{p x p} matrix of (unscaled) covariances of the
      \eqn{coef[j], j=1,...p}.}
    \item{Sum Sq}{a 3-vector with the model's Sum of Squares Regression 
      (SSR), Sum of Squares Error (SSE), and Sum of Squares Total (SST).}
}
\description{
\code{model_combo} calculates the linear model for a linear combination of
  phenotypes as a function of a set of predictors.
}
\examples{
ex_data <- pcsstools_example[c("g1", "x1", "x2", "x3", "y1", "y2", "y3")]
head(ex_data)
means <- colMeans(ex_data)
covs <- cov(ex_data)
n <- nrow(ex_data)
phi <- c("y1" = 1, "y2" = -1, "y3" = 0.5)

model_combo(
  y1 + y2 + y3 ~ g1 + x1 + x2 + x3, 
  phi = phi, n = n, means = means, covs = covs
)

summary(lm(y1 - y2 + 0.5 * y3 ~ g1 + x1 + x2 + x3, data = ex_data))
}
\references{
{

  \insertRef{wolf_computationally_2020}{pcsstools}
  
  \insertRef{gasdaska_leveraging_2019}{pcsstools}

}
}
