% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge3D.R
\name{NPEstd.tetra}
\alias{NPEstd.tetra}
\title{The vertices of the Proportional Edge (PE) Proximity Region in the standard regular tetrahedron}
\usage{
NPEstd.tetra(p, r, rv = NULL)
}
\arguments{
\item{p}{A 3D point whose PE proximity region is to be computed.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{rv}{Index of the vertex region containing the point, either \code{1,2,3,4} or \code{NULL}
(default is \code{NULL}).}
}
\value{
Vertices of the tetrahedron which constitutes the PE proximity region with expansion parameter
\code{r} and circumcenter (or center of mass) for a point \code{p} in the standard regular tetrahedron
}
\description{
Returns the vertices of the PE proximity region (which is itself a tetrahedron) for a point in the
standard regular tetrahedron \eqn{T_h=T((0,0,0),(1,0,0),(1/2,\sqrt{3}/2,0),(1/2,\sqrt{3}/6,\sqrt{6}/3))=}
\code{(rv=1,rv=2,rv=3,rv=4)}.

PE proximity region is defined with respect to the tetrahedron \eqn{T_h}
with expansion parameter \eqn{r \ge 1} and vertex regions based on the circumcenter of \eqn{T_h} (which is equivalent
to the center of mass in the standard regular tetrahedron).

Vertex regions are labeled as \code{1,2,3,4} rowwise for the vertices of the tetrahedron \eqn{T_h}.
\code{rv} is the index of the vertex region \code{p} resides, with default=\code{NULL}.
If \code{p} is outside of \eqn{T_h}, it returns \code{NULL} for the proximity region.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)

n<-3
Xp<-runif.std.tetra(n)$g
r<-1.5
NPEstd.tetra(Xp[1,],r)

#or try
RV<-rel.vert.tetraCC(Xp[1,],tetra)$rv
NPEstd.tetra(Xp[1,],r,rv=RV)

NPEstd.tetra(c(-1,-1,-1),r,rv=NULL)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NPEtetra}}, \code{\link{NPEtri}} and \code{\link{NPEint}}
}
\author{
Elvan Ceyhan
}
