% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{Idom.num2ASbasic.tri}
\alias{Idom.num2ASbasic.tri}
\title{The indicator for two points being a dominating set for Arc Slice Proximity Catch Digraphs
(AS-PCDs) - standard basic triangle case}
\usage{
Idom.num2ASbasic.tri(
  p1,
  p2,
  Xp,
  c1,
  c2,
  M = "CC",
  rv1 = NULL,
  rv2 = NULL,
  ch.data.pnts = FALSE
)
}
\arguments{
\item{p1, p2}{Two 2D points to be tested for constituting a dominating set of the AS-PCD.}

\item{Xp}{A set of 2D points which constitutes the vertices of the AS-PCD.}

\item{c1, c2}{Positive real numbers which constitute the vertex of the standard basic triangle
adjacent to the shorter edges; \eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.}

\item{M}{The center of the triangle. \code{"CC"} stands for circumcenter of the triangle \eqn{T_b} or a 2D point in Cartesian coordinates or
a 3D point in barycentric coordinates which serves as a center in the interior of the triangle \eqn{T_b};
default is \code{M="CC"} i.e., the circumcenter of \eqn{T_b}.}

\item{rv1, rv2}{The indices of the vertices whose regions contains \code{p1} and \code{p2}, respectively.
They take the vertex labels as \eqn{1,2,3} as in the row order of the vertices in \eqn{T_b}
(default is \code{NULL} for both).}

\item{ch.data.pnts}{A logical argument for checking whether points \code{p1} and \code{p2} are data points in \code{Xp} or not
(default is \code{FALSE}).}
}
\value{
\eqn{I(}\{\code{p1,p2}\} is a dominating set of the AS-PCD\eqn{)} where the vertices of AS-PCD are the 2D data set \code{Xp}),
that is, returns 1 if \{\code{p1,p2}\} is a dominating set of AS-PCD, returns 0 otherwise
}
\description{
Returns \eqn{I(}\{\code{p1,p2}\} is a dominating set of AS-PCD\eqn{)} where vertices of AS-PCD are the 2D
data set \code{Xp}), that is, returns 1 if \{\code{p1,p2}\} is a dominating set of AS-PCD, returns 0 otherwise.

AS proximity regions are defined with respect to the standard basic triangle \eqn{T_b=T(c(0,0),c(1,0),c(c1,c2))},
In the standard basic triangle, \eqn{T_b}, \eqn{c_1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Any given triangle can be mapped to the standard basic triangle by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling, preserving uniformity of the points in the
original triangle. Hence standard basic triangle is useful for simulation
studies under the uniformity hypothesis.

Point, \code{p1}, is in the vertex region of vertex \code{rv1} (default is \code{NULL})
and point, \code{p2}, is in the vertex region of vertex \code{rv2} (default is \code{NULL}); vertices are labeled as \eqn{1,2,3}
in the order they are stacked row-wise.

Vertex regions are based on the center \code{M="CC"} for circumcenter
of \eqn{T_b}; or \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of \eqn{T_b}; default is \code{M="CC"}.

\code{ch.data.pnts} is for checking whether points \code{p1} and \code{p2} are data points in \code{Xp} or not
(default is \code{FALSE}), so by default this function checks whether the points \code{p1} and \code{p2} would be a
dominating set if they actually were in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\dontrun{
c1<-.4; c2<-.6;
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C)
n<-10

set.seed(1)
Xp<-runif.basic.tri(n,c1,c2)$g

M<-as.numeric(runif.basic.tri(1,c1,c2)$g)  #try also M<-c(.6,.2)

Idom.num2ASbasic.tri(Xp[1,],Xp[2,],Xp,c1,c2,M)
Idom.num2ASbasic.tri(Xp[1,],Xp[1,],Xp,c1,c2,M)  #one point can not a dominating set of size two

Idom.num2ASbasic.tri(c(.2,.4),c(.2,.5),rbind(c(.2,.4),c(.2,.5)),c1,c2,M)

ind.gam2<-vector()
for (i in 1:(n-1))
  for (j in (i+1):n)
  {if (Idom.num2ASbasic.tri(Xp[i,],Xp[j,],Xp,c1,c2,M)==1)
   ind.gam2<-rbind(ind.gam2,c(i,j))}
ind.gam2

#or try
rv1<-rel.vert.basic.triCC(Xp[1,],c1,c2)$rv
rv2<-rel.vert.basic.triCC(Xp[2,],c1,c2)$rv
Idom.num2ASbasic.tri(Xp[1,],Xp[2,],Xp,c1,c2,M,rv1,rv2)
Idom.num2ASbasic.tri(c(.2,.4),Xp[2,],Xp,c1,c2,M,rv1,rv2)

#or try
rv1<-rel.vert.basic.triCC(Xp[1,],c1,c2)$rv
Idom.num2ASbasic.tri(Xp[1,],Xp[2,],Xp,c1,c2,M,rv1)

#or try
Rv2<-rel.vert.basic.triCC(Xp[2,],c1,c2)$rv
Idom.num2ASbasic.tri(Xp[1,],Xp[2,],Xp,c1,c2,M,rv2=Rv2)

Idom.num2ASbasic.tri(c(.3,.2),c(.35,.25),Xp,c1,c2,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Idom.num2AStri}}
}
\author{
Elvan Ceyhan
}
