% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim1D.R
\name{CSarc.dens.test1D}
\alias{CSarc.dens.test1D}
\title{A test of segregation/association based on arc density of Central Similarity Proximity Catch Digraph
(CS-PCD) for 1D data}
\usage{
CSarc.dens.test1D(
  Xp,
  Yp,
  t,
  c = 0.5,
  support.int = NULL,
  end.int.cor = FALSE,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)
}
\arguments{
\item{Xp}{A set of 1D points which constitute the vertices of the CS-PCD.}

\item{Yp}{A set of 1D points which constitute the end points of the partition intervals.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number which serves as the centrality parameter in CS proximity region;
must be in \eqn{(0,1)} (default \code{c=.5}).}

\item{support.int}{Support interval \eqn{(a,b)} with \eqn{a<b}.
Uniformity of \code{Xp} points in this interval is tested. Default is \code{NULL}.}

\item{end.int.cor}{A logical argument for end interval correction, default is \code{FALSE},
recommended when both \code{Xp} and \code{Yp} have the same interval support.}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}.}

\item{conf.level}{Level of the confidence interval, default is \code{0.95}, for the arc density
CS-PCD whose vertices are the 1D data set \code{Xp}.}
}
\value{
A \code{list} with the elements
\item{statistic}{Test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding \code{alternative}.}
\item{conf.int}{Confidence interval for the arc density at the given confidence level \code{conf.level} and
depends on the type of \code{alternative}.}
\item{estimate}{Estimate of the parameter, i.e., arc density}
\item{null.value}{Hypothesized value for the parameter, i.e., the null arc density, which is usually the
mean arc density under uniform distribution.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set}
}
\description{
An object of class \code{"htest"} (i.e., hypothesis test) function which performs a hypothesis test of complete spatial
randomness (CSR) or uniformity of \code{Xp} points in the range (i.e., range) of \code{Yp} points against the alternatives
of segregation (where \code{Xp} points cluster away from \code{Yp} points) and association (where \code{Xp} points cluster around
\code{Yp} points) based on the normal approximation of the arc density of the CS-PCD for uniform 1D data.

The function yields the test statistic, \eqn{p}-value for the corresponding \code{alternative},
the confidence interval, estimate and null value for the parameter of interest (which is the arc density),
and method and name of the data set used.

Under the null hypothesis of uniformity of \code{Xp} points in the range of \code{Yp} points, arc density
of CS-PCD whose vertices are \code{Xp} points equals to its expected value under the uniform distribution and
\code{alternative} could be two-sided, or left-sided (i.e., data is accumulated around the \code{Yp} points, or association)
or right-sided (i.e., data is accumulated around the centers of the intervals, or segregation).

CS proximity region is constructed with the expansion parameter \eqn{t > 0} and centrality parameter \code{c} which yields
\eqn{M}-vertex regions. More precisely, for a middle interval \eqn{(y_{(i)},y_{(i+1)})}, the center is
\eqn{M=y_{(i)}+c(y_{(i+1)}-y_{(i)})} for the centrality parameter \eqn{c \in (0,1)}.
This test is more appropriate when supports of \code{Xp} and \code{Yp} has a substantial overlap.

\code{end.int.cor} is for end interval correction, (default is "no end interval correction", i.e., \code{end.int.cor=FALSE}),
recommended when both \code{Xp} and \code{Yp} have the same interval support.
}
\examples{
tau<-2
c<-.4
a<-0; b<-10; int=c(a,b)

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
xf<-(int[2]-int[1])*.1

Xp<-runif(nx,a-xf,b+xf)
Yp<-runif(ny,a,b)

CSarc.dens.test1D(Xp,Yp,tau,c,int)
CSarc.dens.test1D(Xp,Yp,tau,c,int,alt="l")
CSarc.dens.test1D(Xp,Yp,tau,c,int,alt="g")

CSarc.dens.test1D(Xp,Yp,tau,c,int,end.int.cor = TRUE)

Yp2<-runif(ny,a,b)+11
CSarc.dens.test1D(Xp,Yp2,tau,c,int)

n<-10  #try also n<-20
Xp<-runif(n,a,b)
CSarc.dens.test1D(Xp,Yp,tau,c,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{CSarc.dens.test}} and \code{\link{CSarc.dens.test.int}}
}
\author{
Elvan Ceyhan
}
