% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{ind.int.set}
\alias{ind.int.set}
\title{Indices of the intervals where the 1D point(s) reside}
\usage{
ind.int.set(dat, Yp)
}
\arguments{
\item{dat}{A set of 1D points for which the indices of intervals are to be determined.}

\item{Yp}{A set of 1D points from which intervals are constructed.}
}
\value{
The \code{vector} of indices of the intervals in which points in the 1D data set, \code{dat}, reside
}
\description{
Returns the indices of intervals for all the points in 1D data set, \code{dat}, as a vector.

Intervals are based on \code{Yp} and left end interval is labeled as 0, the next interval as 1, and so on.
}
\examples{
a<-0; b<-10; int<-c(a,b)

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
xr<-range(a,b)
xf<-(xr[2]-xr[1])*.1
Xp<-runif(nx,a-xf,b+xf)
Yp<-runif(ny,a,b)  #try also Yp<-runif(ny,a+1,b-1)

ind<-ind.int.set(Xp,Yp)
ind

jit<-.1
yjit<-runif(nx,-jit,jit)

Xlim<-range(a,b,Xp,Yp)
xd<-Xlim[2]-Xlim[1]

plot(cbind(a,0), xlab=" ", ylab=" ",xlim=Xlim+xd*c(-.05,.05),ylim=3*c(-jit,jit),pch=".")
abline(h=0)
points(Xp, yjit,pch=".",cex=3)
abline(v=Yp,lty=2)
text(Xp,yjit,labels=factor(ind))

ind.int.set(3,5)
ind.int.set(6,5)

ind.int.set(Xp,Yp)

}
\author{
Elvan Ceyhan
}
