% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{inTriAll}
\alias{inTriAll}
\title{Check whether all points in a data set are inside the triangle}
\usage{
inTriAll(Dt, tri, boundary = FALSE)
}
\arguments{
\item{Dt}{A set of 2D points representing the set of data points.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{boundary}{A logical parameter (default=\code{FALSE}) to include boundary or not, so if it is \code{TRUE},
the function checks if a point lies in the closure of the triangle (i.e., interior and boundary combined)
else it checks if the point lies in the interior of the triangle.}
}
\value{
A logical output, if all data points in \code{Dt} are inside the triangle, \code{tri}, the output is \code{TRUE},
else it is \code{FALSE}.
}
\description{
Checks if all the data points in the 2D data set, \code{Dt}, lie in the triangle, \code{tri},
using the barycentric coordinates, generally denoted as \eqn{(\alpha,\beta,\gamma)}.

If all (normalized or non-normalized) barycentric coordinates of a point are positive then the point is
inside the triangle, if all are nonnegative with one or more are zero, then the point falls in the boundary.
If some of the barycentric coordinates are negative, then the point falls outside the triangle.

\code{boundary} is a logical argument (default=\code{FALSE}) to include boundary or not, so if it is \code{TRUE},
the function checks if a point lies in the closure of the triangle (i.e., interior and boundary combined)
else it checks if the point lies in the interior of the triangle.
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2); p<-c(1.4,1.2)

Tr<-rbind(A,B,C)

inTriAll(p,Tr)

#for the vertex A
inTriAll(A,Tr)
inTriAll(A,Tr,boundary=TRUE)

#for a point on the edge AB
D3<-(A+B)/2
inTriAll(D3,Tr)
inTriAll(D3,Tr,boundary=TRUE)

#data set
n<-10
dat<-cbind(runif(n),runif(n))
inTriAll(dat,Tr,boundary=TRUE)

dat<-runifTe(n)$gen.points
inTriAll(dat,Tr)
inTriAll(dat,Tr,boundary=TRUE)

dat<-runif.tri(n,Tr)$g
inTriAll(dat,Tr)
inTriAll(dat,Tr,boundary=TRUE)

dat.fr<-data.frame(a=dat)
inTriAll(dat.fr,Tr)

dat.fr<-data.frame(a=Tr)
inTriAll(dat,dat.fr)

}
\seealso{
\code{\link{in.triangle}} and \code{\link[interp]{on.convex.hull}} from the \code{interp} package for documentation for \code{in.convex.hull}
}
\author{
Elvan Ceyhan
}
